/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.get;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetChildrenCount
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(GetChildrenCount.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        String id = request.getParameter("id");
        Boolean showHidden = Boolean.parseBoolean(request.getParameter("showHidden"));
        logger.info("Servlet GetChildrenCount called with parameters: [id: " + id + " - showHidden: " + showHidden + "]");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            int count = this.getChildren(session, id, sessionManager.getLogin(request), showHidden);
            xmlConfig = xstream.toXML((Object)count);
            out.println(xmlConfig);
        }
        catch (Exception e) {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            throw new ServletException((Throwable)e);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    private int getChildren(Session session, String id, String login, Boolean showHidden) throws Exception {
        Node folderNode = session.getNodeByIdentifier(id);
        int count = 0;
        NodeIterator iterator = folderNode.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.nextNode();
            Boolean isHidden = false;
            try {
                String path;
                String name;
                if (!showHidden.booleanValue()) {
                    if (node.hasProperty(NodeProperty.HIDDEN.toString())) {
                        isHidden = node.getProperty(NodeProperty.HIDDEN.toString()).getBoolean();
                    }
                    if (isHidden.booleanValue()) continue;
                }
                if ((name = (path = node.getPath()).substring(path.lastIndexOf(47) + 1)).startsWith("rep:") || name.startsWith("hl:")) continue;
                ++count;
            }
            catch (Exception e) {
                logger.error("Problem getting children count for node ID " + id + ": ", (Object)e.getMessage());
            }
        }
        return count;
    }
}

