/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceItem;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspaceTrashItem
extends JCRWorkspaceItem {
    protected static Logger logger = LoggerFactory.getLogger(JCRWorkspaceTrashItem.class);

    public JCRWorkspaceTrashItem(Node node, String login) throws RepositoryException {
        super(node, login);
        Map map = this.item.getProperties();
        try {
            map.put(NodeProperty.TRASH_ITEM_NAME, node.getProperty(NodeProperty.TRASH_ITEM_NAME.toString()).getString());
            map.put(NodeProperty.DELETE_DATE, this.xstream.toXML((Object)node.getProperty(NodeProperty.DELETE_DATE.toString()).getDate()));
            map.put(NodeProperty.DELETE_BY, node.getProperty(NodeProperty.DELETE_BY.toString()).getString());
            map.put(NodeProperty.DELETED_FROM, node.getProperty(NodeProperty.DELETED_FROM.toString()).getString());
            map.put(NodeProperty.ORIGINAL_PARENT_ID, node.getProperty(NodeProperty.ORIGINAL_PARENT_ID.toString()).getString());
            map.put(NodeProperty.IS_FOLDER, this.xstream.toXML((Object)node.getProperty(NodeProperty.IS_FOLDER.toString()).getBoolean()));
        }
        catch (Exception e) {
            logger.error("Error getting trash item ", (Throwable)e);
        }
        try {
            map.put(NodeProperty.TRASH_ITEM_MIME_TYPE, node.getProperty(NodeProperty.TRASH_ITEM_MIME_TYPE.toString()).getString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            map.put(NodeProperty.LENGTH, this.xstream.toXML((Object)node.getProperty(NodeProperty.LENGTH.toString()).getLong()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

