/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.trash;

import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.j2ee.workspacemanager.storage.GCUBEStorage;
import org.apache.jackrabbit.j2ee.workspacemanager.versioning.JCRVersioning;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRTrash {
    private Logger logger = LoggerFactory.getLogger(JCRTrash.class);
    private Session session;
    private String login;
    private GCUBEStorage storage;
    private String trashPath;

    public JCRTrash(Session session, String login) {
        this.storage = new GCUBEStorage(login);
        this.session = session;
        this.login = login;
        this.trashPath = "/Home/" + login + "/Workspace/Trash/";
    }

    public void deletePermanently(String id) throws InternalErrorException, InsufficientPrivilegesException {
        this.logger.info("Delete permanently item ID " + id + " by user " + this.login);
        try {
            Node node = this.session.getNodeByIdentifier(id);
            this.logger.debug("deletePermanently node: " + node.getPath());
            try {
                this.storage.removeRemoteFolder(node.getPath());
            }
            catch (RemoteBackendException e) {
                this.logger.warn("Error removing " + node.getPath() + " from storage", (Throwable)e);
                throw new InternalErrorException((Throwable)e);
            }
            this.visitTree(node);
            node.remove();
            this.session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private void visitTree(Node root) throws RepositoryException, InsufficientPrivilegesException, InternalErrorException {
        try {
            if (root.hasNode(NodeProperty.CONTENT.toString())) {
                JCRVersioning versioning = new JCRVersioning(this.session, this.login);
                versioning.removeAllVersions(root.getIdentifier());
            }
        }
        catch (RepositoryException e) {
            this.logger.error(root.getPath() + " not deleted.");
        }
        if (root.hasNodes()) {
            NodeIterator iterator = root.getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                this.visitTree(node);
            }
        }
    }

    public void emptyTrash() throws AccessDeniedException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.logger.info("Empty Trash " + this.trashPath + " by user " + this.login);
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        Node trash = this.session.getNode(this.trashPath);
        try {
            this.visitTree(trash);
        }
        catch (InsufficientPrivilegesException e) {
            this.logger.error("Error deleting versions " + this.trashPath + (Object)((Object)e));
        }
        catch (InternalErrorException e) {
            this.logger.error("Error deleting versions " + this.trashPath + (Object)((Object)e));
        }
        this.session.removeItem(this.trashPath);
        this.session.save();
    }

    static /* synthetic */ String access$000(JCRTrash x0) {
        return x0.trashPath;
    }

    static /* synthetic */ GCUBEStorage access$100(JCRTrash x0) {
        return x0.storage;
    }

    static /* synthetic */ Logger access$200(JCRTrash x0) {
        return x0.logger;
    }
}

