/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import org.apache.jackrabbit.j2ee.workspacemanager.util.MultipleOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleOutputStream {
    private Logger logger = LoggerFactory.getLogger(MultipleOutputStream.class);
    MyPipedInputStream s1;
    MyPipedInputStream s2;
    InputStream is;
    MyPipedOututStream os1;
    MyPipedOututStream os2;

    public MultipleOutputStream(InputStream is) throws IOException {
        this.is = is;
        this.os1 = new MyPipedOututStream(this);
        this.os2 = new MyPipedOututStream(this);
        this.s1 = new MyPipedInputStream(this, (PipedOutputStream)this.os1);
        this.s2 = new MyPipedInputStream(this, (PipedOutputStream)this.os2);
    }

    public void startWriting() throws Exception {
        try (BufferedInputStream bis = new BufferedInputStream(this.is);){
            byte[] buf = new byte[65536];
            int read = -1;
            int writeTot = 0;
            while ((read = bis.read(buf)) != -1) {
                if (!this.s1.isClosed()) {
                    this.os1.write(buf, 0, read);
                }
                if (!this.s2.isClosed()) {
                    this.os2.write(buf, 0, read);
                }
                writeTot += read;
                if (!this.os1.isClosed() || !this.os2.isClosed()) continue;
            }
            if (!this.os1.isClosed()) {
                this.os1.close();
            }
            if (!this.os2.isClosed()) {
                this.os2.close();
            }
            this.logger.info("total written " + writeTot);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InputStream getS1() {
        return this.s1;
    }

    public InputStream getS2() {
        return this.s2;
    }

    static /* synthetic */ Logger access$000(MultipleOutputStream x0) {
        return x0.logger;
    }
}

