/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.usermanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDisplayNameServlet
extends HttpServlet {
    public static final String DISPLAY_NAME_LABEL = "hl:displayName";
    public static final String GROUP_NAME = "groupName";
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(GetDisplayNameServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        String displayName = null;
        XStream xstream = null;
        String xmlConfig = null;
        String adminId = request.getSession().getServletContext().getInitParameter("user");
        char[] adminPass = request.getSession().getServletContext().getInitParameter("pass").toCharArray();
        try {
            session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(adminId, adminPass));
            xstream = new XStream();
            String groupName = request.getParameter(GROUP_NAME);
            this.logger.info("Servlet GetDisplayNameServlet called with parameters GROUP_NAME: " + groupName);
            UserManager userManager = session.getUserManager();
            Authorizable authorizable = userManager.getAuthorizable(groupName);
            Group group = null;
            if (authorizable.isGroup()) {
                try {
                    group = (Group)authorizable;
                }
                catch (Exception e) {
                    throw new ServletException("Group " + groupName + " not found " + e.getMessage());
                }
                Value[] displayNameValue = group.getProperty(DISPLAY_NAME_LABEL);
                if (displayNameValue != null) {
                    int size = displayNameValue.length;
                    for (int i = 0; i < size; ++i) {
                        displayName = displayNameValue[i].getString();
                    }
                }
            }
            session.save();
            xmlConfig = xstream.toXML(displayName);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        catch (RepositoryException e) {
            this.logger.error("Error retrieving Display Name ", (Throwable)e);
            xmlConfig = xstream.toXML(displayName);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }
}

