/**
 * 
 */
package org.gcube.spd.spdtools;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;

/**
 * @author Francesco Cerasuolo (francesco.cerasuolo@terradue.com)
 *
 */
public class DateConverter implements IStringConverter<Calendar> {

	/* (non-Javadoc)
	 * @see com.beust.jcommander.IStringConverter#convert(java.lang.String)
	 */
	public Calendar convert(String value) {
		SimpleDateFormat sdf;
		
		// manage the case of empty text in from/to date
		if (value.contentEquals(""))
			return null;
		
		// try to parse ISO_8601
		try {
			sdf = new SimpleDateFormat(Constants.ISO_8601_DATE_PATTERN);
			Date date =sdf.parse(value);
			return convertDateToCalendar(date);
		} catch (ParseException e) {
		}
		
		// try to parse spql format
		try {
			sdf = new SimpleDateFormat(Constants.SPQL_DATE_PATTERN);
			Date date =sdf.parse(value);
			return convertDateToCalendar(date);
		} catch (ParseException e) {
		}

		// not parsed
		throw new ParameterException("Invalid Date format." +
			" Use ISO pattern ("+Constants.ISO_8601_DATE_PATTERN+")" +
			" or spql pattern ("+Constants.SPQL_DATE_PATTERN+")");

	}

	/**
	 * @param date
	 * @return
	 */
	private Calendar convertDateToCalendar(Date date) {
		Calendar c = Calendar.getInstance();
		c.setTime(date);
		return c;
	}

}
