/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spd.spdtools;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateConverter
implements IStringConverter<Calendar> {
    public Calendar convert(String value) {
        if (value.contentEquals("")) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            Date date = sdf.parse(value);
            return this.convertDateToCalendar(date);
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/M/d");
                Date date = sdf.parse(value);
                return this.convertDateToCalendar(date);
            }
            catch (ParseException parseException) {
                throw new ParameterException("Invalid Date format. Use ISO pattern (yyyy-MM-dd'T'HH:mm'Z') or spql pattern (yyyy/M/d)");
            }
        }
    }

    private Calendar convertDateToCalendar(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }
}

