/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.speciesplugin.utils;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.Classification;
import org.gcube.data.spd.client.proxies.DWCACreator;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.client.proxies.Occurrences;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.speciesplugin.store.SpeciesStore;
import org.gcube.data.speciesplugin.utils.SpeciesTreeGenerator;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.delegates.PipedStream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.trees.data.Tree;

public class SpeciesService {
    public static final String SPECIES_SERVICE_ID = "SpeciesServiceId";
    private static GCUBELog logger = new GCUBELog(SpeciesService.class);
    protected SpeciesTreeGenerator generator = new SpeciesTreeGenerator();
    protected File storeLocation;
    protected Manager call;
    protected Occurrences occurrencesCall;
    protected Classification classificationCall;
    protected DWCACreator dwcaCall;
    protected SpeciesStore store;
    protected int treeCounter = 0;

    public SpeciesService(SpeciesStore store) throws Exception {
        this.store = store;
        logger.trace((Object)"CALLING MANAGER ");
        this.call = (Manager)AbstractPlugin.manager().withTimeout(3, TimeUnit.MINUTES).build();
        this.classificationCall = (Classification)AbstractPlugin.classification().withTimeout(3, TimeUnit.MINUTES).build();
    }

    public void createCollection(List<String> scientificNames, List<String> dataSources) throws Exception {
        this.createCollection(scientificNames, dataSources, true);
    }

    public void createCollection(List<String> scientificNames, List<String> dataSources, boolean strictMatch) throws Exception {
        logger.trace((Object)("creating collection with scientificNames: " + scientificNames + " dataSources: " + dataSources));
        String query = this.createQuery(scientificNames, dataSources);
        logger.trace((Object)("SPD query: " + query));
        Stream stream = this.call.search(query.toString());
        logger.trace((Object)("Filtering retrieved scientific names (strictMatch: " + strictMatch + ")"));
        int skipped = 0;
        int accepted = 0;
        while (stream.hasNext()) {
            TaxonomyItem taxon = (TaxonomyItem)stream.next();
            if (!strictMatch || this.checkEquals(scientificNames, taxon.getScientificName())) {
                logger.trace((Object)("Accepted " + taxon.getId() + " " + taxon.getScientificName()));
                ++accepted;
                this.store(taxon);
                continue;
            }
            ++skipped;
        }
        logger.trace((Object)("Creation completed, " + accepted + " accepted Scientific Name " + skipped + " skipped Scientific Name, generated " + this.treeCounter + " total trees"));
    }

    protected String createQuery(List<String> scientificNames, List<String> dataSource) {
        if (scientificNames.size() == 0) {
            throw new IllegalArgumentException("No scientific name specified");
        }
        StringBuilder query = new StringBuilder();
        Iterator<String> itScNames = scientificNames.iterator();
        while (itScNames.hasNext()) {
            query.append("'");
            query.append(itScNames.next());
            query.append("'");
            if (!itScNames.hasNext()) continue;
            query.append(", ");
        }
        query.append(" as ScientificName");
        if (dataSource.size() > 0) {
            query.append(" in ");
            Iterator<String> itDataSource = dataSource.iterator();
            while (itDataSource.hasNext()) {
                query.append(itDataSource.next());
                if (!itDataSource.hasNext()) continue;
                query.append(", ");
            }
        }
        query.append(" return Taxon");
        return query.toString();
    }

    private boolean checkEquals(List<String> scientificNames, String scientificName) {
        for (String name : scientificNames) {
            if (!name.equalsIgnoreCase(scientificName)) continue;
            return true;
        }
        return false;
    }

    protected void store(TaxonomyItem taxon) {
        try {
            Stream taxonomyItems = this.classificationCall.getTaxonTreeById(taxon.getId());
            PipedStream trees = Streams.pipe((Stream)taxonomyItems).through((Generator)this.generator);
            Stream<Tree> outcomes = this.store.add((Stream<Tree>)trees);
            int i = 0;
            while (outcomes.hasNext()) {
                ++i;
                ++this.treeCounter;
                outcomes.next();
            }
            logger.trace((Object)("Generated " + i + " trees from taxon " + taxon));
        }
        catch (Exception e) {
            logger.error((Object)("Failed tree generation for taxon " + taxon), (Throwable)e);
        }
    }
}

