/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.speciesplugin;

import java.io.File;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gcube.common.clients.exceptions.InvalidRequestException;
import org.gcube.data.speciesplugin.SpeciesSource;
import org.gcube.data.speciesplugin.requests.RequestBinder;
import org.gcube.data.speciesplugin.requests.SpeciesRequest;
import org.gcube.data.speciesplugin.store.SpeciesStore;
import org.gcube.data.speciesplugin.utils.SpeciesService;
import org.gcube.data.speciesplugin.utils.SpeciesUpdateScheduler;
import org.gcube.data.tmf.impl.LifecycleAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SpeciesLifecycle
extends LifecycleAdapter {
    private static final long serialVersionUID = 1L;
    public static final String STORAGE_LOCATION = "store";
    protected static RequestBinder db = new RequestBinder();
    private static Logger log = LoggerFactory.getLogger(SpeciesLifecycle.class);
    private final SpeciesSource source;
    protected List<String> scientificNames;
    protected List<String> datasources;
    protected boolean strictMatch;
    protected long lastUpdate = -1L;
    protected transient ScheduledFuture<?> scheduled;
    protected long updatePeriod;
    protected TimeUnit timeUnit;

    public SpeciesLifecycle(SpeciesSource source, List<String> scientificNames, List<String> datasources, boolean strictMatch, long updatePeriod, TimeUnit timeUnit) {
        this.source = source;
        this.scientificNames = scientificNames;
        this.datasources = datasources;
        this.strictMatch = strictMatch;
        this.updatePeriod = updatePeriod;
        this.timeUnit = timeUnit;
    }

    public void init() throws Exception {
        try {
            log.info("initialising source " + this.source.id());
            File location = this.source.environment().file(STORAGE_LOCATION);
            this.source.store().start(location);
            this.loadCollection();
            this.scheduleRefresh();
        }
        catch (Exception e) {
            log.error("An error occurred initializing the source", (Throwable)e);
            throw new Exception("Error occured during species retrieving", e);
        }
    }

    protected void scheduleRefresh() {
        if (this.updatePeriod <= 0L || this.timeUnit == null) {
            log.trace("scheduleRefresh aborted because of invalid parameters updatePeriod: " + this.updatePeriod + " timeUnit: " + (Object)((Object)this.timeUnit));
            return;
        }
        Runnable refresher = new Runnable(){

            @Override
            public void run() {
                SpeciesLifecycle.this.refreshCollection();
            }
        };
        long initialDelay = this.calculateInitialRefreshDelay();
        log.trace("scheduling refresh for source " + this.source.id() + " initialDelay: " + initialDelay + " updatePeriod: " + this.updatePeriod + " timeUnit: " + (Object)((Object)this.timeUnit));
        this.scheduled = SpeciesUpdateScheduler.getInstance().scheduleAtFixedRate(refresher, initialDelay, this.updatePeriod, this.timeUnit);
    }

    protected long calculateInitialRefreshDelay() {
        if (this.lastUpdate < 0L) {
            return 0L;
        }
        if (this.scheduled != null) {
            return 0L;
        }
        long elapsedTime = System.currentTimeMillis() - this.lastUpdate;
        long expectedDelay = this.timeUnit.toMillis(elapsedTime) - elapsedTime;
        return expectedDelay >= 0L ? expectedDelay : 0L;
    }

    protected void rescheduleRefresh() {
        this.unscheduleRefresh();
        this.scheduleRefresh();
    }

    protected void refreshCollection() {
        try {
            this.source.store().delete();
            this.loadCollection();
        }
        catch (Exception e) {
            log.error("An error occurred refreshing the collection for source id " + this.source.id(), (Throwable)e);
        }
    }

    protected void loadCollection() throws Exception {
        SpeciesStore store = this.source.store();
        SpeciesService client = new SpeciesService(store);
        client.createCollection(this.scientificNames, this.datasources, this.strictMatch);
        this.lastUpdate = System.currentTimeMillis();
    }

    public void reconfigure(Element DOMRequest) throws InvalidRequestException {
        log.info("reconfiguring source " + this.source.id());
        SpeciesRequest speciesRequest = db.bind(DOMRequest);
        this.updatePeriod = speciesRequest.getRefreshPeriod();
        this.timeUnit = speciesRequest.getTimeUnit();
        this.rescheduleRefresh();
    }

    public void terminate() {
        log.info("removing source " + this.source.id());
        this.unscheduleRefresh();
        this.source.store().delete();
    }

    public void stop() {
        log.info("stopping source " + this.source.id() + " on container shutdown");
        this.unscheduleRefresh();
        this.source.store().stop();
    }

    protected void unscheduleRefresh() {
        if (this.scheduled != null) {
            this.scheduled.cancel(true);
        }
    }
}

