/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.speciesplugin.utils;

import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.model.CommonName;
import org.gcube.data.spd.model.TaxonomyItem;
import org.gcube.data.spd.model.util.ElementProperty;
import org.gcube.data.speciesplugin.utils.SpeciesService;
import org.gcube.data.streams.exceptions.StreamSkipSignal;
import org.gcube.data.streams.exceptions.StreamStopSignal;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;

public class SpeciesTreeGenerator
implements Generator<TaxonomyItem, Tree> {
    protected static GCUBELog logger = new GCUBELog(SpeciesTreeGenerator.class);

    public Tree yield(TaxonomyItem element) throws StreamSkipSignal, StreamStopSignal {
        Tree tree = new Tree();
        tree.setAttribute(SpeciesService.SPECIES_SERVICE_ID, element.getId());
        Edge propertiesEdge = this.createProperties(element);
        Edge dwcItemEdge = this.createDwCA(element);
        Edge provenanceItemEdge = this.createProvenance(element);
        tree.add(propertiesEdge);
        tree.add(dwcItemEdge);
        tree.add(provenanceItemEdge);
        return tree;
    }

    private Edge createProvenance(TaxonomyItem item) {
        InnerNode provenanceItem = new InnerNode(new Edge[0]);
        Edge provenanceItemEdge = new Edge(new QName("provenance"), (Node)provenanceItem);
        provenanceItem.add(new Edge[]{Nodes.e((String)"wasDerivedFrom", (Object)item.getCitation()), Nodes.e((String)"wasGeneratedBy", (Object)item.getCredits())});
        return provenanceItemEdge;
    }

    private Edge createDwCA(TaxonomyItem item) {
        String subgenus;
        String genus;
        String family;
        String order;
        String claz;
        String phylum;
        Hashtable<String, String> hashTaxa = new Hashtable<String, String>();
        this.getTax(item, hashTaxa);
        String[] name = item.getScientificName().split(" ");
        InnerNode dwcItem = new InnerNode(new Edge[0]);
        Edge dwcItemEdge = new Edge(new QName("DwC"), (Node)dwcItem);
        dwcItem.add(new Edge[]{Nodes.e((String)"scientificNameAuthorship", (Object)item.getAuthor()), Nodes.e((String)"acceptedNameUsageID", (Object)item.getStatus().getRefId()), Nodes.e((String)"taxonomicStatus", (Object)item.getStatus().getStatus()), Nodes.e((String)"taxonRemarks", (Object)item.getStatus().getStatusAsString()), Nodes.e((String)"bibliographicCitation", (Object)item.getCredits()), Nodes.e((String)"scientificNameID", (Object)item.getLsid()), Nodes.e((String)"modified", (Object)item.getModified()), Nodes.e((String)"taxonRank", (Object)item.getRank()), Nodes.e((String)"scientificName", (Object)item.getScientificName()), Nodes.e((String)"nameAccordingTo", (Object)item.getCitation())});
        if (item.getParent() != null) {
            dwcItem.add(Nodes.e((String)"parentNameUsageID", (Object)item.getParent().getId()));
        }
        item.getCitation();
        String kingdom = hashTaxa.get("kingdom");
        if (kingdom != null) {
            dwcItem.add(Nodes.e((String)"kingdom", (Object)kingdom));
        }
        if ((phylum = hashTaxa.get("phylum")) != null) {
            dwcItem.add(Nodes.e((String)"phylum", (Object)phylum));
        }
        if ((claz = hashTaxa.get("class")) != null) {
            dwcItem.add(Nodes.e((String)"class", (Object)claz));
        }
        if ((order = hashTaxa.get("order")) != null) {
            dwcItem.add(Nodes.e((String)"order", (Object)order));
        }
        if ((family = hashTaxa.get("family")) != null) {
            dwcItem.add(Nodes.e((String)"family", (Object)family));
        }
        if ((genus = hashTaxa.get("genus")) != null) {
            dwcItem.add(Nodes.e((String)"genus", (Object)genus));
        }
        if ((subgenus = hashTaxa.get("subgenus")) != null) {
            dwcItem.add(Nodes.e((String)"subgenus", (Object)subgenus));
        }
        if (name.length > 1) {
            dwcItem.add(Nodes.e((String)"specificEpithet", (Object)name[1]));
        }
        if (name.length > 2) {
            dwcItem.add(Nodes.e((String)"infraspecificEpithet", (Object)name[name.length - 1]));
        }
        if (name.length > 2) {
            dwcItem.add(Nodes.e((String)"verbatimTaxonRank", (Object)name[name.length - 2]));
        }
        InnerNode commonNames = new InnerNode(new Edge[0]);
        Edge commonNamesEdge = new Edge(new QName("vernacularNames"), (Node)commonNames);
        dwcItem.add(commonNamesEdge);
        List commonNameList = null;
        commonNameList = item.getCommonNames();
        if (commonNameList != null) {
            for (CommonName c : commonNameList) {
                commonNames.add(new Edge[]{Nodes.e((String)"language", (Object)c.getLanguage()), Nodes.e((String)"locality", (Object)c.getLocality()), Nodes.e((String)"vernacularName", (Object)c.getName())});
            }
        }
        return dwcItemEdge;
    }

    private Edge createProperties(TaxonomyItem item) {
        InnerNode properties = new InnerNode(new Edge[0]);
        Edge propertiesEdge = new Edge(new QName("Properties"), (Node)properties);
        List listProp = null;
        listProp = item.getProperties();
        if (listProp != null) {
            for (ElementProperty property : listProp) {
                properties.add(Nodes.e((String)"property", (Node)Nodes.n((Edge[])new Edge[]{Nodes.e((String)"key", (Object)property.getName()), Nodes.e((String)"value", (Object)property.getValue())})));
            }
        }
        return propertiesEdge;
    }

    private Hashtable<String, String> getTax(TaxonomyItem item, Hashtable<String, String> taxa) {
        taxa.put(item.getRank().toLowerCase(), item.getScientificName());
        if (item.getParent() != null) {
            this.getTax(item.getParent(), taxa);
        }
        return taxa;
    }
}

