/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.speciesplugin;

import java.io.File;
import java.util.List;
import org.gcube.common.clients.exceptions.InvalidRequestException;
import org.gcube.data.speciesplugin.SpeciesSource;
import org.gcube.data.speciesplugin.store.SpeciesStore;
import org.gcube.data.speciesplugin.utils.SpeciesService;
import org.gcube.data.tmf.impl.LifecycleAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SpeciesLifecycle
extends LifecycleAdapter {
    private static final long serialVersionUID = 1L;
    public static final String STORAGE_LOCATION = "store";
    private static Logger log = LoggerFactory.getLogger(SpeciesLifecycle.class);
    private final SpeciesSource source;
    private List<String> scientificNames;
    private List<String> datasources;

    public SpeciesLifecycle(SpeciesSource source, List<String> scientificNames, List<String> datasources) {
        this.source = source;
        this.scientificNames = scientificNames;
        this.datasources = datasources;
    }

    public void init() throws Exception {
        System.out.println("INIT INIT INIT INIT INIT INIT INIT INIT INIT INIT INIT INIT INIT INIT ");
        try {
            log.info("initialising source " + this.source.id());
            File location = this.source.environment().file(STORAGE_LOCATION);
            this.source.store().start(location);
            SpeciesStore store = this.source.store();
            SpeciesService client = new SpeciesService(store);
            client.createCollection(this.scientificNames, this.datasources);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Error occured during species retrieving", e);
        }
    }

    public void reconfigure(Element DOMRequest) throws InvalidRequestException {
        log.info("reconfiguring source " + this.source.id());
    }

    public void terminate() {
        log.info("removing source " + this.source.id());
        this.source.store().delete();
    }

    public void stop() {
        log.info("stopping source " + this.source.id() + " on container shutdown");
        this.source.store().stop();
    }
}

