/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.generators;

import org.gcube.data.streams.delegates.StreamListenerAdapter;
import org.gcube.data.streams.generators.Generator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingListener<E>
extends StreamListenerAdapter
implements Generator<E, E> {
    static Logger log = LoggerFactory.getLogger(LoggingListener.class);
    static long count = 0L;
    static long starttime = 0L;
    private static String rformat = "streamed %1d elements in %2d ms (%3d/sec)";

    @Override
    public void onStart() {
        log.info("started processing");
        starttime = System.currentTimeMillis();
    }

    @Override
    public E yield(E element) {
        ++count;
        return element;
    }

    @Override
    public void onClose() {
        String report;
        if (starttime == 0L) {
            report = "processed 0 elements";
        } else {
            long time = System.currentTimeMillis() - starttime;
            long ratio = Math.round((double)count / (double)time * 1000.0);
            report = String.format(rformat, count, time, ratio);
        }
        log.info(report);
    }
}

