package org.gcube.data.tml.clients.providers;

import org.gcube.common.clients.gcore.GcoreServiceProvider;
import org.gcube.data.tml.Constants;

/**
 * Partial implementation of {@link GcoreServiceProvider} for Tree Manager services.
 * 
 * @param <T>
 *            the type of the service
 */
public abstract class AbstractProvider<T> implements GcoreServiceProvider<T> {
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String serviceClass() {
		return Constants.SERVICE_CLASS;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String serviceName() {
		return Constants.SERVICE_NAME;
	}

}
