package org.gcube.data.tml.clients.providers;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.data.tm.stubs.TBinderPortType;
import org.gcube.data.tm.stubs.service.TBinderServiceAddressingLocator;
import org.gcube.data.tml.Constants;

public class TBinderProvider extends AbstractProvider<TBinderPortType> {

		public static final TBinderProvider INSTANCE = new TBinderProvider();
		
		@Override
		public String name() {
			return Constants.TBINDER_NAME;
		}

		@Override
		public TBinderPortType service(EndpointReferenceType endpoint) {
			try {
				TBinderPortType pt = new TBinderServiceAddressingLocator().getTBinderPortTypePort(endpoint);
				pt = GCUBERemotePortTypeContext.getProxy(pt,GCUBEScopeManager.DEFAULT);
				return pt;
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		}
}
