/**
 * 
 */
package org.gcube.data.tml.uri.tm;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

/**
 * A handler for the <code>cms</code> protocol.
 * @author Fabio Simeoni
 *
 */
public class Handler extends URLStreamHandler {

	/**{@inheritDoc}*/
	@Override protected URLConnection openConnection(URL u) throws IOException {
		return new CMSURLConnection(u);
	}
	
	/**
	 * Registers the protocol with the JVM.
	 */
	public static void activateProtocol() {
		
		String pkgs_name="java.protocol.handler.pkgs";
		String pkgs = System.getProperty(pkgs_name);
		String pkg = "org.gcube.contentmanagement.contentmanager.stubs.model.protocol";
		if (pkgs==null)
			pkgs = pkg ;
		else if (!pkgs.contains(pkg))
			pkgs = pkgs+"|"+pkg;
	
		System.setProperty(pkgs_name, pkgs);	
	}

	
	
}
