/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.clients;

import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.Client;
import org.gcube.common.clients.DiscoveryException;
import org.gcube.common.clients.gcore.GCoreDiscoveryClient;
import org.gcube.common.clients.gcore.GCorePassThroughClient;
import org.gcube.common.clients.gcore.GcoreQuery;
import org.gcube.common.clients.gcore.GcoreServiceProvider;
import org.gcube.common.clients.gcore.StatefulQuery;
import org.gcube.data.tm.stubs.BindOutcome;
import org.gcube.data.tm.stubs.InvalidRequestFault;
import org.gcube.data.tm.stubs.SourceBinding;
import org.gcube.data.tm.stubs.SourceBindings;
import org.gcube.data.tm.stubs.TBinderPortType;
import org.gcube.data.tml.clients.APIUtils;
import org.gcube.data.tml.clients.BinderConsumer;
import org.gcube.data.tml.clients.BindingParameters;
import org.gcube.data.tml.clients.TBinderClient;
import org.gcube.data.tml.clients.providers.TBinderProvider;
import org.gcube.data.tml.exceptions.InvalidRequestException;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.xml.sax.InputSource;

public class BinderClient
implements TBinderClient {
    final Client<TBinderPortType> client;

    public BinderClient(Client<TBinderPortType> client) {
        this.client = client;
    }

    public BinderClient(StatefulQuery query) {
        this((Client<TBinderPortType>)new GCoreDiscoveryClient((GcoreServiceProvider)TBinderProvider.INSTANCE, (GcoreQuery)query));
    }

    public BinderClient(URL address) {
        this((Client<TBinderPortType>)new GCorePassThroughClient((GcoreServiceProvider)TBinderProvider.INSTANCE, APIUtils.endpoint(address, TBinderProvider.INSTANCE.name())));
    }

    @Override
    public List<SourceBinding> bind(final BindingParameters parameters) throws IllegalArgumentException, DiscoveryException, InvalidRequestException, Exception {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters are null");
        }
        APIUtils.TBinderCall<SourceBindings> call = new APIUtils.TBinderCall<SourceBindings>(){

            public SourceBindings call(TBinderPortType service) throws Exception {
                try {
                    return service.bind(parameters.parameters);
                }
                catch (InvalidRequestFault f) {
                    throw new InvalidRequestException(f.getFaultMessage(), f.toException().getCause());
                }
            }
        };
        SourceBindings output = (SourceBindings)this.client.make((Call)call);
        ArrayList<SourceBinding> bindings = new ArrayList<SourceBinding>();
        if (output != null && output.getBindings() != null) {
            for (SourceBinding binding : output.getBindings()) {
                bindings.add(binding);
            }
        }
        return bindings;
    }

    @Override
    public void bindAsync(final BindingParameters parameters, final BinderConsumer consumer) throws IllegalArgumentException, DiscoveryException, Exception {
        if (parameters == null || consumer == null) {
            throw new IllegalArgumentException("parameters or consumers are null");
        }
        APIUtils.TBinderCall<Void> call = new APIUtils.TBinderCall<Void>(){

            public Void call(TBinderPortType service) throws Exception {
                String locatorString = service.bindAsync(parameters.parameters);
                URI locator = null;
                try {
                    locator = new URI(locatorString);
                }
                catch (URISyntaxException e) {
                    throw new Exception("null response", e);
                }
                Iterator iter = new ForwardReader(locator).iterator();
                BindOutcome response = null;
                while (iter.hasNext()) {
                    GenericRecord elem = (GenericRecord)iter.next();
                    if (elem == null) continue;
                    String payload = ((StringField)elem.getField(0)).getPayload();
                    response = (BindOutcome)ObjectDeserializer.deserialize((InputSource)new InputSource(new StringReader(payload)), BindOutcome.class);
                }
                if (response == null) {
                    throw new Exception("asynchronous response is invalid (empty channel)");
                }
                if (response.getSuccess() != null) {
                    ArrayList<SourceBinding> bindings = new ArrayList<SourceBinding>();
                    for (SourceBinding binding : response.getSuccess().getBindings()) {
                        bindings.add(binding);
                    }
                    consumer.onCompletion(bindings);
                } else if (response.getFailure() != null) {
                    consumer.onFailure((Exception)((Object)response.getFailure().getFault()));
                } else {
                    throw new Exception("asyncrhonous response is invalid (no evidence of either failure or success)");
                }
                return null;
            }
        };
        this.client.make((Call)call);
    }
}

