/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.clients;

import java.net.URI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.Client;
import org.gcube.common.clients.DiscoveryException;
import org.gcube.common.clients.gcore.GCoreDiscoveryClient;
import org.gcube.common.clients.gcore.GCorePassThroughClient;
import org.gcube.common.clients.gcore.GcoreQuery;
import org.gcube.common.clients.gcore.GcoreServiceProvider;
import org.gcube.common.clients.gcore.StatefulQuery;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.data.streams.Stream;
import org.gcube.data.tm.stubs.InvalidTreeFault;
import org.gcube.data.tm.stubs.TWriterPortType;
import org.gcube.data.tm.stubs.UnknownTreeFault;
import org.gcube.data.tm.stubs.UnsupportedOperationFault;
import org.gcube.data.tm.stubs.UnsupportedRequestFault;
import org.gcube.data.tm.stubs.UpdateFailure;
import org.gcube.data.tml.clients.APIUtils;
import org.gcube.data.tml.clients.TWriterClient;
import org.gcube.data.tml.clients.providers.TWriterProvider;
import org.gcube.data.tml.clients.queries.QueryBuilder;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.exceptions.UnsupportedOperationException;
import org.gcube.data.tml.exceptions.UnsupportedRequestException;
import org.gcube.data.tml.utils.TMStreams;
import org.gcube.data.tml.utils.Utils;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.Bindings;
import org.gcube.data.trees.streams.TreeStreams;
import org.oasis.wsrf.faults.BaseFaultType;
import org.oasis.wsrf.lifetime.Destroy;
import org.w3c.dom.Element;

public class WriterClient
implements TWriterClient {
    private final Client<TWriterPortType> client;

    public WriterClient(Client<TWriterPortType> client) {
        this.client = client;
    }

    public WriterClient(StatefulQuery query) {
        this((Client<TWriterPortType>)new GCoreDiscoveryClient((GcoreServiceProvider)TWriterProvider.INSTANCE, (GcoreQuery)query));
    }

    public WriterClient(String sourceId) {
        this(QueryBuilder.findWriteSource().withId(sourceId).build());
    }

    public WriterClient(EndpointReferenceType endpoint) {
        this((Client<TWriterPortType>)new GCorePassThroughClient((GcoreServiceProvider)TWriterProvider.INSTANCE, endpoint));
    }

    @Override
    public Tree add(Tree doc) throws DiscoveryException, InvalidTreeException, Exception {
        return this.add(Bindings.toElement((Tree)doc));
    }

    @Override
    public Tree add(final Element doc) throws DiscoveryException, InvalidTreeException, Exception {
        APIUtils.TWriterCall<Tree> call = new APIUtils.TWriterCall<Tree>(){

            public Tree call(TWriterPortType service) throws Exception {
                try {
                    return Utils.toTree(service.add(Utils.toHolder(doc)));
                }
                catch (UnsupportedOperationFault f) {
                    throw new UnsupportedOperationException("operation is not supported by target plugin");
                }
                catch (UnsupportedRequestFault f) {
                    throw new UnsupportedRequestException("request is not supported by target plugin");
                }
                catch (InvalidTreeFault f) {
                    throw new InvalidTreeException("document is invalid", f.toException().getCause());
                }
                catch (GCUBEFault f) {
                    throw f.toException();
                }
            }
        };
        return (Tree)this.client.make((Call)call);
    }

    @Override
    public Stream<Tree> add(Stream<Tree> trees) throws DiscoveryException, Exception {
        URI treeRs = TreeStreams.publishTreesIn(trees).withDefaults();
        return this.add(treeRs);
    }

    @Override
    public Stream<Tree> add(final URI treeRs) throws DiscoveryException, Exception {
        APIUtils.TWriterCall<String> call = new APIUtils.TWriterCall<String>(){

            public String call(TWriterPortType service) throws Exception {
                try {
                    return service.addRS(treeRs.toString());
                }
                catch (UnsupportedOperationFault f) {
                    throw new UnsupportedOperationException("operation is not supported by target plugin");
                }
                catch (UnsupportedRequestFault f) {
                    throw new UnsupportedRequestException("request is not supported by target plugin");
                }
                catch (GCUBEFault f) {
                    throw f.toException();
                }
            }
        };
        String outcomeRs = (String)this.client.make((Call)call);
        return TMStreams.addedTreesIn(URI.create(outcomeRs));
    }

    @Override
    public void update(final Tree doc) throws Exception, DiscoveryException, InvalidTreeException, UnknownTreeException {
        APIUtils.TWriterCall<Void> call = new APIUtils.TWriterCall<Void>(){

            public Void call(TWriterPortType service) throws Exception {
                try {
                    service.update(Utils.toHolder(Bindings.toElement((Tree)doc)));
                    return null;
                }
                catch (UnsupportedOperationFault f) {
                    throw new UnsupportedOperationException("operation is not supported by target plugin");
                }
                catch (UnsupportedRequestFault f) {
                    throw new UnsupportedRequestException("request is not supported by target plugin");
                }
                catch (InvalidTreeFault f) {
                    throw new InvalidTreeException("delta tree is malformed", f.toException().getCause());
                }
                catch (UnknownTreeFault f) {
                    throw new UnknownTreeException("delta tree does not identify a known tree", f.toException().getCause());
                }
                catch (GCUBEFault f) {
                    throw f.toException();
                }
            }
        };
        this.client.make((Call)call);
    }

    @Override
    public Stream<UpdateFailure> update(Stream<Tree> deltas) throws Exception, DiscoveryException {
        URI deltaRs = TreeStreams.publishTreesIn(deltas).withDefaults();
        return this.update(deltaRs);
    }

    @Override
    public Stream<UpdateFailure> update(final URI locator) throws Exception, DiscoveryException {
        APIUtils.TWriterCall<String> call = new APIUtils.TWriterCall<String>(){

            public String call(TWriterPortType service) throws Exception {
                try {
                    return service.updateRS(locator.toString());
                }
                catch (UnsupportedOperationFault f) {
                    throw new UnsupportedOperationException("operation is not supported by target plugin");
                }
                catch (UnsupportedRequestFault f) {
                    throw new UnsupportedRequestException("request is not supported by target plugin");
                }
                catch (GCUBEFault f) {
                    throw f.toException();
                }
            }
        };
        String failuresRs = (String)this.client.make((Call)call);
        return TMStreams.updateFailuresIn(URI.create(failuresRs));
    }

    synchronized void delete() throws Exception {
        APIUtils.TWriterCall<Void> call = new APIUtils.TWriterCall<Void>(){

            public Void call(TWriterPortType service) throws Exception {
                try {
                    service.destroy(new Destroy());
                    return null;
                }
                catch (BaseFaultType f) {
                    throw new GCUBEUnrecoverableException((Throwable)f);
                }
            }
        };
        this.client.make((Call)call);
    }
}

