/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.clients;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.Client;
import org.gcube.common.clients.DiscoveryException;
import org.gcube.common.clients.gcore.GCoreDiscoveryClient;
import org.gcube.common.clients.gcore.GCorePassThroughClient;
import org.gcube.common.clients.gcore.GcoreQuery;
import org.gcube.common.clients.gcore.GcoreServiceProvider;
import org.gcube.common.clients.gcore.StatefulQuery;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.tm.stubs.GetByIDParams;
import org.gcube.data.tm.stubs.GetByIDsParams;
import org.gcube.data.tm.stubs.GetParams;
import org.gcube.data.tm.stubs.InvalidTreeFault;
import org.gcube.data.tm.stubs.Path;
import org.gcube.data.tm.stubs.TReaderPortType;
import org.gcube.data.tm.stubs.UnknownPathFault;
import org.gcube.data.tm.stubs.UnknownTreeFault;
import org.gcube.data.tm.stubs.UnsupportedOperationFault;
import org.gcube.data.tm.stubs.UnsupportedRequestFault;
import org.gcube.data.tml.clients.APIUtils;
import org.gcube.data.tml.clients.TReaderClient;
import org.gcube.data.tml.clients.providers.TReaderProvider;
import org.gcube.data.tml.clients.queries.QueryBuilder;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownPathException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.exceptions.UnsupportedOperationException;
import org.gcube.data.tml.exceptions.UnsupportedRequestException;
import org.gcube.data.tml.uri.URIs;
import org.gcube.data.tml.utils.TMStreams;
import org.gcube.data.tml.utils.Utils;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.Bindings;
import org.gcube.data.trees.patterns.EdgePattern;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.gcube.data.trees.streams.TreeStreams;
import org.oasis.wsrf.faults.BaseFaultType;
import org.oasis.wsrf.lifetime.Destroy;
import org.w3c.dom.Element;

public class ReaderClient
implements TReaderClient {
    private final Client<TReaderPortType> client;

    public ReaderClient(Client<TReaderPortType> client) {
        this.client = client;
    }

    public ReaderClient(StatefulQuery query) {
        this((Client<TReaderPortType>)new GCoreDiscoveryClient((GcoreServiceProvider)TReaderProvider.INSTANCE, (GcoreQuery)query));
    }

    public ReaderClient(String sourceId) {
        this(QueryBuilder.findReadSource().withId(sourceId).build());
    }

    public ReaderClient(EndpointReferenceType endpoint) {
        this((Client<TReaderPortType>)new GCorePassThroughClient((GcoreServiceProvider)TReaderProvider.INSTANCE, endpoint));
    }

    public static Node resolve(URI uri) throws IllegalArgumentException, URISyntaxException, DiscoveryException, UnsupportedOperationException, UnknownPathException, Exception {
        String sourceId = URIs.sourceId(uri);
        ReaderClient call = new ReaderClient(sourceId);
        return call.getNode(URIs.nodeIDs(uri));
    }

    @Override
    public Element getAsElement(final String id, final Pattern pattern) throws UnknownTreeException, UnsupportedOperationException, DiscoveryException, Exception {
        APIUtils.TReaderCall<Element> call = new APIUtils.TReaderCall<Element>(){

            public Element call(TReaderPortType service) throws Exception {
                GetByIDParams params = new GetByIDParams(Utils.toHolder(pattern), id);
                try {
                    return Utils.toElement(service.getByID(params));
                }
                catch (UnsupportedOperationFault f) {
                    throw new UnsupportedOperationException("operation is not supported by target plugin");
                }
                catch (UnsupportedRequestFault f) {
                    throw new UnsupportedRequestException("request is not supported by target plugin");
                }
                catch (UnknownTreeFault f) {
                    throw new UnknownTreeException(id + " does not identify a tree", f.toException().getCause());
                }
                catch (InvalidTreeFault f) {
                    throw new InvalidTreeException(pattern + " does not match tree with identifier " + id, f.toException().getCause());
                }
                catch (GCUBEFault f) {
                    throw f.toException();
                }
            }
        };
        return (Element)this.client.make((Call)call);
    }

    @Override
    public Tree get(String id) throws UnknownTreeException, DiscoveryException, UnsupportedOperationException, Exception {
        return this.get(id, (Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
    }

    @Override
    public Tree get(String id, Pattern pattern) throws UnknownTreeException, DiscoveryException, UnsupportedOperationException, Exception {
        return Bindings.fromElement((Element)this.getAsElement(id, pattern));
    }

    @Override
    public Element getAsElement(String id) throws DiscoveryException, UnsupportedOperationException, UnknownTreeException, Exception {
        return this.getAsElement(id, (Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
    }

    @Override
    public Stream<Tree> get(final URI loc, final Pattern pattern) throws DiscoveryException, UnsupportedOperationException, Exception {
        APIUtils.TReaderCall<String> call = new APIUtils.TReaderCall<String>(){

            public String call(TReaderPortType service) throws Exception {
                GetByIDsParams params = new GetByIDsParams(loc.toString(), Utils.toHolder(pattern));
                try {
                    return service.getByIDs(params);
                }
                catch (UnsupportedOperationFault f) {
                    throw new UnsupportedOperationException("operation is not supported by target plugin");
                }
                catch (UnsupportedRequestFault f) {
                    throw new UnsupportedRequestException("request is not supported by target plugin");
                }
                catch (GCUBEFault f) {
                    throw f.toException();
                }
            }
        };
        String locator = (String)this.client.make((Call)call);
        return TreeStreams.treesIn((URI)URI.create(locator));
    }

    @Override
    public Stream<Tree> get(Stream<String> identifiers, Pattern pattern) throws DiscoveryException, UnsupportedOperationException, Exception {
        URI rs = Streams.publishStringsIn(identifiers).withDefaults();
        return this.get(rs, pattern);
    }

    @Override
    public Stream<Tree> get(URI loc) throws DiscoveryException, UnsupportedOperationException, Exception {
        return this.get(loc, (Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
    }

    @Override
    public Stream<Tree> get(Stream<String> identifiers) throws DiscoveryException, UnsupportedOperationException, Exception {
        return this.get(identifiers, (Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
    }

    @Override
    public Stream<Tree> get(final Pattern pattern) throws DiscoveryException, UnsupportedOperationException, Exception {
        APIUtils.TReaderCall<String> call = new APIUtils.TReaderCall<String>(){

            public String call(TReaderPortType service) throws Exception {
                try {
                    return service.get(new GetParams(Utils.toHolder(pattern)));
                }
                catch (UnsupportedOperationFault f) {
                    throw new UnsupportedOperationException("operation is not supported by target plugin");
                }
                catch (UnsupportedRequestFault f) {
                    throw new UnsupportedRequestException("request is not supported by target plugin");
                }
                catch (GCUBEFault f) {
                    throw f.toException();
                }
            }
        };
        String locator = (String)this.client.make((Call)call);
        return TreeStreams.treesIn((URI)URI.create(locator));
    }

    @Override
    public Stream<Tree> get() throws DiscoveryException, UnsupportedOperationException, Exception {
        return this.get((Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
    }

    @Override
    public Element getNodeAsElement(final String ... ids) throws IllegalArgumentException, DiscoveryException, UnsupportedOperationException, UnknownPathException, Exception {
        if (ids == null || ids.length == 0) {
            throw new IllegalArgumentException("no ids specified");
        }
        APIUtils.TReaderCall<Element> call = new APIUtils.TReaderCall<Element>(){

            public Element call(TReaderPortType service) throws Exception {
                try {
                    return Utils.toElement(service.getNode(new Path(ids)));
                }
                catch (UnsupportedOperationFault f) {
                    throw new UnsupportedOperationException("operation is not supported by target plugin");
                }
                catch (UnsupportedRequestFault f) {
                    throw new UnsupportedRequestException("request is not supported by target plugin");
                }
                catch (UnknownPathFault f) {
                    throw new UnknownPathException(Arrays.asList(ids) + " do not identify a node", f.toException().getCause());
                }
                catch (GCUBEFault f) {
                    throw f.toException();
                }
            }
        };
        return (Element)this.client.make((Call)call);
    }

    @Override
    public Node getNode(String ... path) throws IllegalArgumentException, DiscoveryException, UnsupportedOperationException, UnknownPathException, Exception {
        return Bindings.nodeFromElement((Element)this.getNodeAsElement(path));
    }

    @Override
    public Stream<Node> getNodes(Stream<Path> paths) throws DiscoveryException, UnsupportedOperationException, Exception {
        URI pathRs = TMStreams.publishPathsIn(paths).withDefaults();
        return this.getNodes(pathRs);
    }

    @Override
    public Stream<Node> getNodes(final URI paths) throws DiscoveryException, UnsupportedOperationException, Exception {
        APIUtils.TReaderCall<String> call = new APIUtils.TReaderCall<String>(){

            public String call(TReaderPortType service) throws Exception {
                try {
                    return service.getNodes(paths.toString());
                }
                catch (UnsupportedOperationFault f) {
                    throw new UnsupportedOperationException("operation is not supported by target plugin");
                }
                catch (UnsupportedRequestFault f) {
                    throw new UnsupportedRequestException("request is not supported by target plugin");
                }
                catch (GCUBEFault f) {
                    throw f.toException();
                }
            }
        };
        String locator = (String)this.client.make((Call)call);
        return TreeStreams.nodesIn((URI)URI.create(locator));
    }

    synchronized void delete() throws Exception {
        APIUtils.TReaderCall<Void> call = new APIUtils.TReaderCall<Void>(){

            public Void call(TReaderPortType service) throws Exception {
                try {
                    service.destroy(new Destroy());
                    return null;
                }
                catch (BaseFaultType f) {
                    throw new GCUBEUnrecoverableException((Throwable)f);
                }
            }
        };
        this.client.make((Call)call);
    }
}

