/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.utils;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import javax.xml.namespace.QName;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.dsl.publish.PublishRsWithClause;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tm.stubs.AddOutcome;
import org.gcube.data.tm.stubs.AddOutcomeFailure;
import org.gcube.data.tm.stubs.AddOutcomeSuccess;
import org.gcube.data.tm.stubs.InvalidTreeFault;
import org.gcube.data.tm.stubs.Path;
import org.gcube.data.tm.stubs.UnknownTreeFault;
import org.gcube.data.tm.stubs.UpdateFailure;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.outcomes.AddTreeOutcome;
import org.gcube.data.tml.outcomes.UpdateTreeFailure;
import org.gcube.data.tml.utils.TMStreamLogger;
import org.gcube.data.tml.utils.Utils;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.xml.sax.InputSource;

public class TMStreams {
    public static <N extends Node> Stream<N> log(Stream<N> stream) {
        TMStreamLogger logger = new TMStreamLogger();
        return Streams.monitor((Stream)Streams.pipe(stream).through(logger)).with(logger);
    }

    public static Stream<Path> pathsIn(URI locator) {
        return Streams.pipe((Stream)Streams.stringsIn((URI)locator)).through((Generator)new PathParser());
    }

    public static Stream<Tree> addedTreesIn(URI locator) {
        return Streams.pipe((Stream)Streams.stringsIn((URI)locator)).through((Generator)new AddOutcomeIdParser());
    }

    public static Stream<UpdateFailure> updateFailuresIn(URI locator) {
        return Streams.pipe((Stream)Streams.stringsIn((URI)locator)).through((Generator)new UpdateFailureParser());
    }

    public static PublishRsWithClause<Path> publishPathsIn(Stream<Path> stream) {
        return Streams.publish(stream).using((Generator)new PathSerialiser());
    }

    public static PublishRsWithClause<UpdateTreeFailure> publishUpdateFailures(Stream<UpdateTreeFailure> stream) {
        return Streams.publish(stream).using((Generator)new UpdateTreeFailureSerialiser());
    }

    public static PublishRsWithClause<AddTreeOutcome> publishAddOutcomes(Stream<AddTreeOutcome> stream) {
        return Streams.publish(stream).using((Generator)new AddTreesOutcomeSerialiser());
    }

    private static class AddTreesOutcomeSerialiser
    implements Generator<AddTreeOutcome, String> {
        private AddTreesOutcomeSerialiser() {
        }

        public String yield(AddTreeOutcome outcome) {
            try {
                AddOutcome stubOutcome = new AddOutcome();
                if (outcome.isFailure()) {
                    Exception failure = outcome.failure();
                    Throwable fault = failure instanceof InvalidTreeException ? new InvalidTreeFault() : new GCUBEFault();
                    fault = Utils.newFault(fault, failure);
                    stubOutcome.setFailure(new AddOutcomeFailure((GCUBEFault)fault));
                } else {
                    stubOutcome.setSuccess(new AddOutcomeSuccess(Utils.toHolder(outcome.tree())));
                }
                StringWriter w = new StringWriter();
                ObjectSerializer.serialize((Writer)w, (Object)stubOutcome, (QName)AddOutcome.getTypeDesc().getXmlType());
                return w.toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class UpdateTreeFailureSerialiser
    implements Generator<UpdateTreeFailure, String> {
        private UpdateTreeFailureSerialiser() {
        }

        public String yield(UpdateTreeFailure outcome) {
            try {
                Throwable fault = null;
                Exception failure = outcome.failure();
                fault = failure instanceof UnknownTreeException ? new UnknownTreeFault() : (failure instanceof InvalidTreeException ? new InvalidTreeFault() : new GCUBEFault());
                fault = Utils.newFault(fault, failure);
                UpdateFailure failureStub = new UpdateFailure((GCUBEFault)fault, outcome.identifier());
                StringWriter w = new StringWriter();
                ObjectSerializer.serialize((Writer)w, (Object)failureStub, (QName)UpdateFailure.getTypeDesc().getXmlType());
                return w.toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class PathSerialiser
    implements Generator<Path, String> {
        private PathSerialiser() {
        }

        public String yield(Path path) {
            try {
                StringWriter w = new StringWriter();
                ObjectSerializer.serialize((Writer)w, (Object)path, (QName)Path.getTypeDesc().getXmlType());
                return w.toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class UpdateFailureParser
    implements Generator<String, UpdateFailure> {
        private UpdateFailureParser() {
        }

        public UpdateFailure yield(String element) {
            try {
                return (UpdateFailure)ObjectDeserializer.deserialize((InputSource)new InputSource(new StringReader(element)), UpdateFailure.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class AddOutcomeIdParser
    implements Generator<String, Tree> {
        private AddOutcomeIdParser() {
        }

        public Tree yield(String element) {
            try {
                AddOutcome outcome = (AddOutcome)ObjectDeserializer.deserialize((InputSource)new InputSource(new StringReader(element)), AddOutcome.class);
                if (outcome.getSuccess() != null) {
                    return Utils.toTree(outcome.getSuccess().getOutput());
                }
                throw outcome.getFailure().getFault().toException();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class PathParser
    implements Generator<String, Path> {
        private PathParser() {
        }

        public Path yield(String element) {
            try {
                return (Path)ObjectDeserializer.deserialize((InputSource)new InputSource(new StringReader(element)), Path.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

