package org.gcube.data.tml.proxies;

import static org.gcube.common.clients.exceptions.FaultDSL.*;
import static org.gcube.data.tml.utils.Utils.*;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.Callback;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.data.tm.stubs.SourceBinding;
import org.gcube.data.tm.stubs.SourceBindings;
import org.gcube.data.tm.stubs.TBinderPortType;

/**
 * Default implementation of {@link TBinder} and {@link AsyncTBinder}.
 * 
 * @author Fabio Simeoni
 *
 */
public class DefaultTBinder implements TBinder,AsyncTBinder {

	private final AsyncProxyDelegate<TBinderPortType> delegate;
	
	/**
	 * Creates an instance with {@link ProxyDelegate}
	 * @param delegate the delegate
	 */
	public DefaultTBinder(ProxyDelegate<TBinderPortType> delegate) {
		this.delegate=new AsyncProxyDelegate<TBinderPortType>(delegate);
	}
	
	@Override
	public List<Binding> bind(final BindParams parameters) {
		
		notNull(parameters);
		
		try {
			return delegate.make(bindCall(parameters));
		}
		catch(Exception e) {
			throw again(e).asServiceException();
		}
	}
	
	@Override
	public Future<List<Binding>> bindAsync(BindParams parameters) {
		
		notNull(parameters);
		
		return delegate.makeAsync(bindCall(parameters));
		
	}
	
	@Override
	public Future<?> bindAsync(BindParams parameters, Callback<List<Binding>> callback) throws RejectedExecutionException {
		
		notNull(parameters,callback);
		
		return delegate.makeAsync(bindCall(parameters),callback);
		
	}
	
	//generates calls shared by sync and async operations
	private Call<TBinderPortType, List<Binding>> bindCall(final BindParams parameters) {

		return new Call<TBinderPortType, List<Binding>>() {
			
			@Override
			public List<Binding> call(TBinderPortType endpoint) throws Exception {
				
				SourceBindings output = endpoint.bind(parameters.toStub());
				
				List<Binding> bindings = new ArrayList<Binding>();
				
				if (output!=null && output.getBindings()!=null)
					for (SourceBinding binding : output.getBindings()) 
						bindings.add(new Binding(binding));
				
				return bindings;
				
			}
			
		};
	}
	

}
