/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tm.publishers;

import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;

public class ResilientScheduler
extends GCUBEScheduledHandler<Void> {
    private int attempts = 3;
    private long delay = 1L;

    public ResilientScheduler(long interval, GCUBEScheduledHandler.Mode mode) {
        super(interval, mode, new GCUBEHandler[0]);
    }

    protected synchronized boolean repeat(Exception exception, int exceptionCount) {
        if (exception == null) {
            return false;
        }
        if (exceptionCount >= this.getAttempts()) {
            this.logger.error((Object)"could not publish source profile (final attempt)", (Throwable)exception);
            return false;
        }
        this.logger.warn((Object)("could not publish source profile (attempt " + exceptionCount + " of " + this.getAttempts()), (Throwable)exception);
        if (this.getInterval() < this.getDelay()) {
            this.setInterval(this.getDelay());
        }
        return true;
    }

    public synchronized int getAttempts() {
        return this.attempts;
    }

    public synchronized void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public synchronized long getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(long delay) {
        this.delay = delay;
    }
}

