package org.gcube.data.analysis.statisticalmanager.proxies;



import org.gcube.common.clients.config.Property;
import org.gcube.common.clients.gcore.builders.StatefulBuilder;
import org.gcube.common.clients.gcore.builders.StatefulBuilderImpl;
import org.gcube.common.clients.gcore.builders.StatelessBuilderImpl;
import org.gcube.data.analysis.statisticalmanager.plugins.StatisticalManagerDataSpaceImporterPlugin;
import org.gcube.data.analysis.statisticalmanager.plugins.StatisticalManagerDataSpacePlugin;
import org.gcube.data.analysis.statisticalmanager.plugins.StatisticalManagerFactoryPlugin;
import org.gcube.data.analysis.statisticalmanager.plugins.StatisticalManagerServicePlugin;
import org.gcube.data.analysis.statisticalmanager.stubs.DataSpaceImporterPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.DataSpacePortType;
import org.gcube.data.analysis.statisticalmanager.stubs.FactoryPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.StatisticalServicePortType;



public class StatisticalManagerDSL {
	
	private static final StatisticalManagerFactoryPlugin factory_plugin = new StatisticalManagerFactoryPlugin();
	private static final StatisticalManagerServicePlugin service_plugin = new StatisticalManagerServicePlugin();
	private static final StatisticalManagerDataSpacePlugin dataSpace_plugin = new StatisticalManagerDataSpacePlugin();
	private static final StatisticalManagerDataSpaceImporterPlugin dataSpaceImporter_plugin = new StatisticalManagerDataSpaceImporterPlugin();
	
	
	public static StatefulBuilder<StatisticalManagerService> stateful() {
		return new StatefulBuilderImpl<StatisticalServicePortType,StatisticalManagerService>(service_plugin);
	}
	
	public static StatelessBuilderImpl<FactoryPortType,? extends StatisticalManagerFactory> createStateful() {
		return new StatelessBuilderImpl<FactoryPortType,StatisticalManagerDefaultFactory>(factory_plugin);
	}
	
	public static StatelessBuilderImpl<FactoryPortType,? extends StatisticalManagerAsyncFactory> createStatefulAsync() {
		Property<Long> infinite_timeout = Property.timeout(0);
		return new StatelessBuilderImpl<FactoryPortType,StatisticalManagerDefaultFactory>(factory_plugin, infinite_timeout);
	}
	
	public static StatelessBuilderImpl<DataSpacePortType,? extends StatisticalManagerDataSpace> dataSpace() {	
		return new StatelessBuilderImpl<DataSpacePortType,StatisticalManagerDefaultDataSpace>(dataSpace_plugin);
	}

	public static StatefulBuilder<StatisticalManagerDataSpaceImporter> dataSpaceImporter() {
		return new StatefulBuilderImpl<DataSpaceImporterPortType,StatisticalManagerDataSpaceImporter>(dataSpaceImporter_plugin);
	}
	
}
