package org.gcube.data.analysis.statisticalmanager.proxies;

import java.io.File;
import java.util.List;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.gcube.data.analysis.statisticalmanager.stubs.SMImporters;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImportersRequest;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.streams.Stream;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadataList;

public interface StatisticalManagerDataSpace {
	
	SMTableMetadataList getTableMetadata(String user);
	
	SMTableMetadataList getTableMetadata(String user, String template);
	
	String getDBParameters(String tableId);
	
	W3CEndpointReference createTableFromCSV(File file, boolean hasHeader, String tableName,
			TableTemplates tableTemplate, String description, String user);

	W3CEndpointReference createTableFromDataStream(Stream<OccurrencePoint> points,
			String tableName, String description, String user);
	
	List<W3CEndpointReference> getImporters(String user, String template);
}
