/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.dataminermanagercl.server;

import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient4WPSBuilder;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClientDirector;
import org.gcube.data.analysis.dataminermanagercl.server.util.ServiceCredentials;
import org.gcube.data.analysis.dataminermanagercl.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMinerService {
    private Logger logger = LoggerFactory.getLogger(DataMinerService.class);

    public SClient getClient() throws Exception {
        ServiceCredentials serviceCredential = this.getServiceCredentials();
        SClient4WPSBuilder sBuilder = new SClient4WPSBuilder(serviceCredential);
        SClientDirector director = new SClientDirector();
        director.setSClientBuilder(sBuilder);
        director.constructSClient();
        SClient sClient = director.getSClient();
        this.logger.debug("" + sClient);
        return sClient;
    }

    public SClient getClient(String token) throws Exception {
        ServiceCredentials serviceCredential = this.getServiceCredentials(token);
        SClient4WPSBuilder sBuilder = new SClient4WPSBuilder(serviceCredential);
        SClientDirector director = new SClientDirector();
        director.setSClientBuilder(sBuilder);
        director.constructSClient();
        SClient sClient = director.getSClient();
        this.logger.debug("" + sClient);
        return sClient;
    }

    public SClient getClient(String token, String serviceAddressUrl) throws Exception {
        ServiceCredentials serviceCredential = this.getServiceCredentials(token);
        SClient4WPSBuilder sBuilder = new SClient4WPSBuilder(serviceCredential, serviceAddressUrl);
        SClientDirector director = new SClientDirector();
        director.setSClientBuilder(sBuilder);
        director.constructSClient();
        SClient sClient = director.getSClient();
        this.logger.debug("" + sClient);
        return sClient;
    }

    private ServiceCredentials getServiceCredentials() throws ServiceException {
        String userName = null;
        String token = null;
        String scope = null;
        this.logger.debug("Production Mode");
        try {
            this.logger.debug("Retrieving token credentials");
            token = SecurityTokenProvider.instance.get();
            AuthorizationEntry entry = Constants.authorizationService().get(token);
            userName = entry.getClientInfo().getId();
            scope = entry.getContext();
        }
        catch (Exception e) {
            this.logger.error("Error Retrieving token credentials: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
        ServiceCredentials serviceCredential = new ServiceCredentials(userName, scope, token);
        this.logger.debug("Credential: " + serviceCredential);
        return serviceCredential;
    }

    private ServiceCredentials getServiceCredentials(String token) throws ServiceException {
        String userName = null;
        String scope = null;
        this.logger.debug("Production Mode");
        if (token == null || token.isEmpty()) {
            this.logger.error("Error Retrieving token credentials: token=" + token);
            throw new ServiceException("Error Retrieving token credentials: token=" + token);
        }
        try {
            this.logger.debug("Retrieving token credentials");
            AuthorizationEntry entry = Constants.authorizationService().get(token);
            userName = entry.getClientInfo().getId();
            scope = entry.getContext();
        }
        catch (Exception e) {
            this.logger.error("Error Retrieving token credentials: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
        ServiceCredentials serviceCredential = new ServiceCredentials(userName, scope, token);
        this.logger.debug("Credential: " + serviceCredential);
        return serviceCredential;
    }
}

