/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.dataminermanagercl.server.dmservice;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.opengis.ows.x11.BoundingBoxType;
import net.opengis.wps.x100.CapabilitiesDocument;
import net.opengis.wps.x100.ComplexDataType;
import net.opengis.wps.x100.ExecuteDocument;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.InputType;
import net.opengis.wps.x100.OutputDataType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessBriefType;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.ResponseDocumentType;
import net.opengis.wps.x100.SupportedComplexDataInputType;
import net.opengis.wps.x100.impl.ExecuteResponseDocumentImpl;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.wps.ProcessInformations;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.wps.ResponseWPS;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.wps.SClient4WPSSession;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.wps.WPS2DM;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.wps.computationsvalue.ComputationValueBuilder;
import org.gcube.data.analysis.dataminermanagercl.server.is.InformationSystemUtils;
import org.gcube.data.analysis.dataminermanagercl.server.storage.StorageUtil;
import org.gcube.data.analysis.dataminermanagercl.server.util.ServiceCredentials;
import org.gcube.data.analysis.dataminermanagercl.shared.Constants;
import org.gcube.data.analysis.dataminermanagercl.shared.data.OutputData;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationData;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationId;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationItemPropertiesValue;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationValue;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.FileResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.ImageResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.MapResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.ObjectResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.Resource;
import org.gcube.data.analysis.dataminermanagercl.shared.exception.ServiceException;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.ObjectParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.TabularListParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.process.ComputationStatus;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.data.analysis.dataminermanagercl.shared.process.OperatorCategory;
import org.gcube.data.analysis.dataminermanagercl.shared.process.OperatorsClassification;
import org.n52.wps.client.ExecuteRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SClient4WPS
extends SClient {
    private static final long serialVersionUID = 1909871837115147159L;
    private static Logger logger = LoggerFactory.getLogger(SClient4WPS.class);
    private static final String OTHERS = "OTHERS";
    private String wpsToken;
    private String wpsUser;
    private String wpsProcessingServlet;
    private String wpsCancelComputationServlet;
    private ProcessDescriptionType[] processesDescriptionType;
    private ProcessBriefType[] processesBriefs;
    private HashMap<String, ProcessInformations> process = new HashMap();
    private HashMap<ComputationId, ProcessInformations> runningProcess = new HashMap();
    private SClient4WPSSession wpsClient;

    public SClient4WPS(ServiceCredentials serviceCredentials) throws ServiceException {
        List<String> serviceAddress;
        if (serviceCredentials == null) {
            logger.error("Error credetials are null!");
            throw new ServiceException("Error credetials are null!");
        }
        String token = serviceCredentials.getToken();
        if (token == null || token.isEmpty()) {
            logger.error("Error authorization token invalid: " + token);
            throw new ServiceException("Error authorization token invalid: " + token);
        }
        this.wpsToken = token;
        String userName = serviceCredentials.getUsername();
        if (userName == null || userName.isEmpty()) {
            logger.error("Error invalid user name: " + userName);
            throw new ServiceException("Error invalid user name: " + userName);
        }
        this.wpsUser = userName;
        try {
            serviceAddress = InformationSystemUtils.retrieveServiceAddress("DataAnalysis", "DataMiner", serviceCredentials.getScope());
        }
        catch (Exception e) {
            logger.error("Error retrieving service address: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
        logger.debug("Service Address retrieved:" + serviceAddress);
        if (serviceAddress == null || serviceAddress.size() < 1) {
            logger.error("No DataMiner service address available!");
            throw new ServiceException("No DataMiner service address available!");
        }
        logger.info("DataMiner service address found: " + serviceAddress.get(0));
        this.wpsProcessingServlet = serviceAddress.get(0);
        int wpsWebProcessingServiceIndex = this.wpsProcessingServlet.indexOf("WebProcessingService");
        if (wpsWebProcessingServiceIndex <= 0) {
            logger.error("Cancel computation servlet not available!");
            throw new ServiceException("Cancel computation servlet not available!");
        }
        String wpsServiceUrl = this.wpsProcessingServlet.substring(0, wpsWebProcessingServiceIndex);
        this.wpsCancelComputationServlet = wpsServiceUrl + "CancelComputationServlet";
        logger.debug("Cancel computation servlet: " + this.wpsCancelComputationServlet);
    }

    public SClient4WPS(ServiceCredentials serviceCredentials, String serviceAddressUrl) throws ServiceException {
        if (serviceCredentials == null) {
            logger.error("Error credetials are null!");
            throw new ServiceException("Error credetials are null!");
        }
        String token = serviceCredentials.getToken();
        if (token == null || token.isEmpty()) {
            logger.error("Error authorization token invalid: " + token);
            throw new ServiceException("Error authorization token invalid: " + token);
        }
        this.wpsToken = token;
        String userName = serviceCredentials.getUsername();
        if (userName == null || userName.isEmpty()) {
            logger.error("Error invalid user name: " + userName);
            throw new ServiceException("Error invalid user name: " + userName);
        }
        this.wpsUser = userName;
        logger.debug("Service Address:" + serviceAddressUrl);
        if (serviceAddressUrl == null || serviceAddressUrl.isEmpty()) {
            logger.error("Invalid DataMiner service address: " + serviceAddressUrl);
            throw new ServiceException("Invalid DataMiner service address: " + serviceAddressUrl);
        }
        logger.info("DataMiner service address: " + serviceAddressUrl);
        this.wpsProcessingServlet = serviceAddressUrl + "WebProcessingService";
        this.wpsCancelComputationServlet = serviceAddressUrl + "CancelComputationServlet";
    }

    private SClient4WPSSession createWPSClientSession() {
        if (this.wpsClient == null) {
            this.wpsClient = new SClient4WPSSession(this.wpsUser, this.wpsToken);
            logger.debug("Created StatWPSClientSession");
            return this.wpsClient;
        }
        logger.debug("Use already created StatWPSClientSession");
        return this.wpsClient;
    }

    @Override
    public Operator getOperatorById(String id) throws Exception {
        if (id == null || id.isEmpty()) {
            String error = "Invalid operator request, id=" + id;
            logger.error(error);
            throw new ServiceException(error);
        }
        List<OperatorsClassification> operatorsClassifications = this.getOperatorsClassifications();
        if (operatorsClassifications != null && operatorsClassifications.size() > 0) {
            Operator operator = null;
            for (OperatorsClassification oc : operatorsClassifications) {
                for (Operator op : oc.getOperators()) {
                    if (op.getId().compareToIgnoreCase(id) != 0) continue;
                    operator = op;
                    break;
                }
                if (operator == null) continue;
                break;
            }
            if (operator == null) {
                String error = "Operator not found (" + id + ")";
                logger.error(error);
                throw new ServiceException(error);
            }
            logger.debug("Operator Name: " + operator.getName() + " (" + operator.getId() + ")");
            logger.debug("Operator: " + operator);
            return operator;
        }
        logger.debug("OperatorsClassification void");
        String error = "Operator not found (" + id + ")";
        logger.error(error);
        throw new ServiceException(error);
    }

    @Override
    public List<OperatorsClassification> getOperatorsClassifications() throws ServiceException {
        String categoryName;
        LinkedHashMap<String, String> operatorsToCategoriesMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, ArrayList<Operator>> categoriesToOperatorsMap = new LinkedHashMap<String, ArrayList<Operator>>();
        this.requestCapability();
        if (this.processesBriefs == null || this.processesDescriptionType == null) {
            throw new ServiceException("Algorithms WPS not available!");
        }
        for (ProcessBriefType processBrief : this.processesBriefs) {
            String[] categorySplitted;
            String categoryTitle = processBrief.getTitle().getStringValue();
            categoryName = categoryTitle == null || categoryTitle.isEmpty() ? OTHERS : ((categorySplitted = categoryTitle.split(":")).length < 1 ? OTHERS : categorySplitted[0]);
            operatorsToCategoriesMap.put(processBrief.getIdentifier().getStringValue(), categoryName);
        }
        for (ProcessDescriptionType processDescriptionType : this.processesDescriptionType) {
            ArrayList<Operator> listOperators;
            String briefDescription = processDescriptionType.getAbstract().getStringValue();
            categoryName = (String)operatorsToCategoriesMap.get(processDescriptionType.getIdentifier().getStringValue());
            if (categoryName == null || categoryName.isEmpty()) {
                categoryName = OTHERS;
            }
            if ((listOperators = (ArrayList<Operator>)categoriesToOperatorsMap.get(categoryName)) == null) {
                listOperators = new ArrayList<Operator>();
            }
            listOperators.add(new Operator(processDescriptionType.getIdentifier().getStringValue(), processDescriptionType.getTitle().getStringValue(), briefDescription, processDescriptionType.getAbstract().getStringValue(), null));
            categoriesToOperatorsMap.put(categoryName, listOperators);
        }
        ArrayList<OperatorCategory> categories = new ArrayList<OperatorCategory>();
        ArrayList<Operator> operators = new ArrayList<Operator>();
        Comparator<OperatorCategory> categoriesComparator = new Comparator<OperatorCategory>(){

            @Override
            public int compare(OperatorCategory c1, OperatorCategory c2) {
                return c1.getName().compareTo(c2.getName());
            }
        };
        Comparator<Operator> operatorsComparator = new Comparator<Operator>(){

            @Override
            public int compare(Operator c1, Operator c2) {
                return c1.getName().compareTo(c2.getName());
            }
        };
        for (String categoryName2 : categoriesToOperatorsMap.keySet()) {
            OperatorCategory category = new OperatorCategory(categoryName2, categoryName2, categoryName2);
            List listOperators = (List)categoriesToOperatorsMap.get(categoryName2);
            for (Operator operator : listOperators) {
                operator.setCategory(category);
            }
            Collections.sort(listOperators, operatorsComparator);
            category.setOperators(listOperators);
            operators.addAll(listOperators);
            categories.add(category);
        }
        Collections.sort(operators, operatorsComparator);
        Collections.sort(categories, categoriesComparator);
        ArrayList<OperatorsClassification> operatorsClass = new ArrayList<OperatorsClassification>();
        OperatorsClassification op = new OperatorsClassification(Constants.UserClassificationName, categories, operators);
        operatorsClass.add(op);
        return operatorsClass;
    }

    private ProcessInformations describeProcess(String processId) throws ServiceException {
        return this.describeProcess(processId, null);
    }

    private ProcessInformations describeProcess(String processId, URL processDescriptionURL) throws ServiceException {
        if (this.process.containsKey(processId)) {
            return this.process.get(processId);
        }
        SClient4WPSSession wpsClient = null;
        try {
            wpsClient = this.createWPSClientSession();
            logger.debug("Describe Process WPS URL: " + this.wpsProcessingServlet);
            ProcessDescriptionType processDescription = null;
            for (int k = 0; k <= 3; ++k) {
                block12: {
                    try {
                        processDescription = wpsClient.getProcessDescription(this.wpsProcessingServlet, processId);
                    }
                    catch (Throwable e) {
                        logger.error("Error getProcessDescription for process " + processId + " with WPS URL: " + this.wpsProcessingServlet);
                        if (k != 3) break block12;
                        throw e;
                    }
                }
                if (processDescription != null) break;
            }
            ProcessInformations processInformations = new ProcessInformations(processDescription);
            if (processDescriptionURL != null) {
                processDescription.set((XmlObject)XmlString.Factory.parse((URL)processDescriptionURL));
            }
            logger.debug("ProcessDescription: " + processDescription);
            InputDescriptionType[] inputList = processDescription.getDataInputs().getInputArray();
            logger.debug("WPSClient->Fetching Inputs");
            for (InputDescriptionType input : inputList) {
                logger.debug("WPSClient->Input: " + input);
            }
            OutputDescriptionType[] outputList = processDescription.getProcessOutputs().getOutputArray();
            logger.debug("WPSClient->Fetching Outputs");
            for (OutputDescriptionType output : outputList) {
                logger.debug("WPSClient->Output: " + output);
            }
            processInformations.setInputs(inputList);
            processInformations.setOutputs(outputList);
            this.process.put(processId, processInformations);
            ProcessInformations processInformations2 = processInformations;
            return processInformations2;
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
        finally {
            wpsClient.disconnect(this.wpsProcessingServlet);
        }
    }

    private void requestCapability() throws ServiceException {
        SClient4WPSSession wpsClient = null;
        this.processesDescriptionType = null;
        this.processesBriefs = null;
        try {
            wpsClient = this.createWPSClientSession();
            wpsClient.connect(this.wpsProcessingServlet);
            this.processesDescriptionType = wpsClient.getAllProcessDescriptions(this.wpsProcessingServlet);
            CapabilitiesDocument capabilitiesDocument = wpsClient.getWPSCaps(this.wpsProcessingServlet);
            this.processesBriefs = capabilitiesDocument.getCapabilities().getProcessOfferings().getProcessArray();
            return;
        }
        catch (Throwable e) {
            logger.error("RequestCapability(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
        finally {
            if (wpsClient != null) {
                wpsClient.disconnect(this.wpsProcessingServlet);
            }
        }
    }

    private String executeProcessAsync(ExecuteRequestBuilder executeBuilder, ProcessDescriptionType processDescription) throws ServiceException {
        SClient4WPSSession wpsClient = null;
        try {
            try {
                OutputDescriptionType[] odts;
                for (OutputDescriptionType odt : odts = processDescription.getProcessOutputs().getOutputArray()) {
                    if (!odt.isSetComplexOutput()) continue;
                    executeBuilder.setMimeTypeForOutput("text/xml", odt.getIdentifier().getStringValue());
                }
            }
            catch (Exception e) {
                logger.debug("Execute Process-> Warning, no xml structured objects will be provided: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
            ExecuteDocument execute = executeBuilder.getExecute();
            execute.getExecute().setService("WPS");
            wpsClient = this.createWPSClientSession();
            wpsClient.connect(this.wpsProcessingServlet);
            logger.debug("Sending: " + execute);
            if (execute.getExecute().getResponseForm() != null) {
                ResponseDocumentType documentType = execute.getExecute().getResponseForm().getResponseDocument();
                documentType.setStoreExecuteResponse(true);
                documentType.setStatus(true);
                documentType.setLineage(false);
                execute.getExecute().getResponseForm().setResponseDocument(documentType);
            }
            Object responseObject = wpsClient.execute(this.wpsProcessingServlet, execute);
            String processLocation = null;
            Date creationData = null;
            if (responseObject != null) {
                if (!(responseObject instanceof ExecuteResponseDocumentImpl)) {
                    throw new ServiceException("Invalid response from service, response isn't instance of ExecuteResponseDocumentImpl, class is " + responseObject.getClass());
                }
            } else {
                throw new ServiceException("Invalid Response from service, " + responseObject);
            }
            ExecuteResponseDocumentImpl executeResponseDocumentImpl = (ExecuteResponseDocumentImpl)responseObject;
            processLocation = executeResponseDocumentImpl.getExecuteResponse().getStatusLocation();
            creationData = executeResponseDocumentImpl.getExecuteResponse().getStatus().getCreationTime().getTime();
            logger.debug("Retrieved: [ProcessLocation=" + processLocation + ", CreationDate=" + creationData + "]");
            String string = processLocation;
            return string;
        }
        catch (Throwable e) {
            logger.error("ExecuteProcessAsync: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
        finally {
            try {
                if (wpsClient != null) {
                    wpsClient.disconnect(this.wpsProcessingServlet);
                }
            }
            catch (Exception e) {
                logger.debug("Problems in wps disconnect! " + e.getLocalizedMessage());
            }
        }
    }

    private ExecuteResponseDocument.ExecuteResponse.ProcessOutputs retrieveProcessResult(String processLocation) throws ServiceException {
        SClient4WPSSession wpsClient = null;
        try {
            logger.debug("RetrieveProcessResult: " + processLocation);
            wpsClient = this.createWPSClientSession();
            Object responseObject = null;
            if (processLocation == null || processLocation.length() <= 0) {
                throw new ServiceException("Process Location is null!");
            }
            responseObject = wpsClient.executeViaGET(processLocation, "");
            logger.debug("Response:\n" + responseObject);
            ExecuteResponseDocument.ExecuteResponse.ProcessOutputs processOutputs = ((ExecuteResponseDocument)responseObject).getExecuteResponse().getProcessOutputs();
            return processOutputs;
        }
        catch (Throwable e) {
            logger.debug("RetrieveProcessResult: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
        finally {
            wpsClient.disconnect(this.wpsProcessingServlet);
        }
    }

    private static int calculateBBDimensions(String bbstring) {
        String[] bbinput = bbstring.split(",");
        int dimcounter = 0;
        try {
            for (int i = 0; i < bbinput.length; ++i) {
                Double.parseDouble(bbinput[i]);
                ++dimcounter;
            }
        }
        catch (Exception e) {
            logger.debug("Dimensions Count: " + dimcounter);
        }
        return dimcounter;
    }

    private static void addBoundingBoxInput(ExecuteRequestBuilder executeBuilder, String identifier, String BBstring) {
        ExecuteDocument executor = executeBuilder.getExecute();
        InputType input1 = executor.getExecute().getDataInputs().addNewInput();
        input1.addNewIdentifier().setStringValue(identifier);
        BoundingBoxType bbtype = input1.addNewData().addNewBoundingBoxData();
        String[] bbinput = BBstring.split(",");
        int dimensions = SClient4WPS.calculateBBDimensions(BBstring);
        ArrayList<String> lc = new ArrayList<String>();
        for (int i = 0; i < dimensions / 2; ++i) {
            lc.add(bbinput[i]);
        }
        ArrayList<String> uc = new ArrayList<String>();
        for (int i = dimensions / 2; i < dimensions; ++i) {
            uc.add(bbinput[i]);
        }
        bbtype.setLowerCorner(lc);
        bbtype.setUpperCorner(uc);
        String crs = bbinput[dimensions];
        bbtype.setCrs(crs);
        bbtype.setDimensions(new BigInteger("" + dimensions / 2));
    }

    private static LinkedHashMap<String, ResponseWPS> retrieveURLsFromWPSResponse(ComplexDataType cdt) {
        Node node = cdt.getDomNode();
        LinkedHashMap<String, ResponseWPS> urls = new LinkedHashMap<String, ResponseWPS>();
        SClient4WPS.getURLFromXML(node, urls);
        for (String key : urls.keySet()) {
            logger.debug("ResponseWPS Map: " + key + "-->" + urls.get(key));
        }
        return urls;
    }

    private static void getURLFromXML(Node node, ResponseWPS responseWPS) {
        if (node == null) {
            return;
        }
        logger.debug("Node Name: " + node.getNodeName());
        if (node.getNodeName() == null) {
            return;
        }
        if (node.getFirstChild() == null) {
            logger.debug("FirstChild is NULL");
            return;
        }
        logger.debug("Node Value: " + node.getFirstChild().getNodeValue());
        switch (node.getNodeName()) {
            case "d4science:Data": {
                String text = node.getFirstChild().getNodeValue();
                responseWPS.setData(text);
                break;
            }
            case "d4science:Description": {
                String text = node.getFirstChild().getNodeValue();
                responseWPS.setDescription(text);
                break;
            }
            case "d4science:MimeType": {
                String text = node.getFirstChild().getNodeValue();
                responseWPS.setMimeType(text);
                break;
            }
        }
    }

    private static void getURLFromXML(Node node, LinkedHashMap<String, ResponseWPS> urls) {
        if (node == null) {
            return;
        }
        logger.debug("Node Name: " + node.getNodeName());
        if (node.getNodeName() == null) {
            return;
        }
        ResponseWPS responseWPS = null;
        NodeList listnodes = node.getChildNodes();
        int nChildren = listnodes.getLength();
        switch (node.getNodeName()) {
            case "ogr:Result": {
                NamedNodeMap attrs = node.getAttributes();
                Node n = attrs.getNamedItem("fid");
                String key = n.getNodeValue();
                responseWPS = new ResponseWPS();
                urls.put(key, responseWPS);
                if (nChildren == 0) break;
                for (int i = 0; i < nChildren; ++i) {
                    SClient4WPS.getURLFromXML(listnodes.item(i), responseWPS);
                }
                break;
            }
            default: {
                if (nChildren == 0) break;
                for (int i = 0; i < nChildren; ++i) {
                    SClient4WPS.getURLFromXML(listnodes.item(i), urls);
                }
            }
        }
    }

    @Override
    public List<Parameter> getInputParameters(Operator operator) throws ServiceException {
        try {
            ProcessInformations processInformations;
            logger.info("Parameters of algorithm " + operator.getId());
            try {
                processInformations = this.describeProcess(operator.getId());
            }
            catch (Throwable e) {
                logger.error("GetParameters: " + e.getLocalizedMessage());
                e.printStackTrace();
                throw new ServiceException(e.getLocalizedMessage());
            }
            logger.debug("ProcessInformation: " + processInformations);
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            for (InputDescriptionType inputDesc : processInformations.getInputs()) {
                Parameter inputParameter = WPS2DM.convert2DMType(inputDesc);
                logger.debug("InputParameter: " + inputParameter);
                parameters.add(inputParameter);
            }
            logger.debug("Parameters: " + parameters);
            return parameters;
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    @Override
    public ComputationId startComputation(Operator operator) throws ServiceException {
        ProcessInformations processInformations;
        try {
            processInformations = this.describeProcess(operator.getId());
        }
        catch (Throwable e) {
            logger.error("GetParameters: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
        LinkedHashMap<String, Parameter> inputParameters = new LinkedHashMap<String, Parameter>();
        for (InputDescriptionType inputDesc : processInformations.getInputs()) {
            Parameter inputParameter = WPS2DM.convert2DMType(inputDesc);
            logger.debug("InputParameter: " + inputParameter);
            inputParameters.put(inputParameter.getName(), inputParameter);
        }
        List<Parameter> params = operator.getOperatorParameters();
        LinkedHashMap<String, String> userInputs = new LinkedHashMap<String, String>();
        for (Parameter parm : params) {
            userInputs.put(parm.getName(), parm.getValue());
            logger.debug("UserInputs[key=" + parm.getName() + ", value=" + parm.getValue() + "]");
        }
        LinkedHashMap<String, String> equivalentRequestMap = new LinkedHashMap<String, String>();
        String processUrl = this.compute(processInformations, userInputs, inputParameters, equivalentRequestMap);
        logger.debug("Stated Computation ProcessLocation:" + processUrl);
        int idIndex = processUrl.lastIndexOf("?id=");
        if (idIndex <= -1) {
            logger.error("Invalid processLocation: " + processUrl);
            throw new ServiceException("Invalid processLocation: " + processUrl);
        }
        String id = processUrl.substring(idIndex + 4, processUrl.length());
        String equivalentRequest = this.extractEquivalentRequestForComputation(operator, equivalentRequestMap);
        ComputationId computationId = new ComputationId(id, processUrl, operator.getId(), operator.getName(), equivalentRequest);
        logger.debug("ComputationId: " + computationId);
        this.runningProcess.put(computationId, processInformations);
        return computationId;
    }

    private String extractEquivalentRequestForComputation(Operator operator, LinkedHashMap<String, String> equivalentRequestMap) {
        String equivalentRequest = this.wpsProcessingServlet + "?" + "request=Execute&service=WPS&Version=1.0.0&gcube-token=" + this.wpsToken + "&lang=en-US&Identifier=" + operator.getId() + "&DataInputs=";
        for (String key : equivalentRequestMap.keySet()) {
            String keyEncoded = "";
            try {
                keyEncoded = URLEncoder.encode(key, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Error in equivalent request creation: Unsupported Encoding for parameter=" + key, (Throwable)e);
                break;
            }
            String valueEncoded = "";
            try {
                valueEncoded = URLEncoder.encode(equivalentRequestMap.get(key), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Error in equivalent request creation: Unsupported Encoding for value=" + equivalentRequestMap.get(key) + " of parameter=" + key, (Throwable)e);
                break;
            }
            equivalentRequest = equivalentRequest + keyEncoded + "=" + valueEncoded + ";";
        }
        return equivalentRequest;
    }

    private String compute(ProcessInformations processInformations, Map<String, String> userInputs, Map<String, Parameter> inputParameters, LinkedHashMap<String, String> equivalentRequestMap) throws ServiceException {
        try {
            ExecuteRequestBuilder executeBuilder = new ExecuteRequestBuilder(processInformations.getProcessDescription());
            for (InputDescriptionType input : processInformations.getInputs()) {
                String value = userInputs.get(input.getIdentifier().getStringValue());
                if (value == null || value.trim().length() <= 0) continue;
                if (input.isSetLiteralData()) {
                    logger.debug("Configuring Literal: " + input.getIdentifier().getStringValue() + " to: " + value);
                    equivalentRequestMap.put(input.getIdentifier().getStringValue(), value);
                    executeBuilder.addLiteralData(input.getIdentifier().getStringValue(), value);
                    continue;
                }
                if (input.isSetBoundingBoxData()) {
                    logger.debug("Configuring Bounding Box: " + input.getIdentifier().getStringValue() + " to: " + value);
                    equivalentRequestMap.put(input.getIdentifier().getStringValue(), value);
                    SClient4WPS.addBoundingBoxInput(executeBuilder, input.getIdentifier().getStringValue(), value);
                    continue;
                }
                if (input.isSetComplexData()) {
                    String publicLink;
                    logger.debug("Configuring Complex: " + input.getIdentifier().getStringValue() + " to: " + value);
                    SupportedComplexDataInputType complex = input.getComplexData();
                    Parameter par = inputParameters.get(input.getIdentifier().getStringValue());
                    if (par instanceof TabularListParameter) {
                        ByteArrayInputStream tablesStream = new ByteArrayInputStream(value.getBytes());
                        publicLink = StorageUtil.saveOnStorageInTemporalFile(tablesStream);
                    } else {
                        publicLink = value;
                    }
                    equivalentRequestMap.put(input.getIdentifier().getStringValue(), value);
                    executeBuilder.addComplexDataReference(input.getIdentifier().getStringValue(), publicLink, complex.getDefault().getFormat().getSchema(), complex.getDefault().getFormat().getEncoding(), complex.getDefault().getFormat().getMimeType());
                    continue;
                }
                logger.error("This input parameter type is not supported by client library: " + input);
                throw new ServiceException("This input parameter is not supported by client library: " + input);
            }
            String statusLocation = this.executeProcessAsync(executeBuilder, processInformations.getProcessDescription());
            logger.debug("Starting Process: " + statusLocation);
            return statusLocation;
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public ComputationStatus getComputationStatus(ComputationId computationId) throws ServiceException {
        SClient4WPSSession wpsClient = null;
        try {
            ComputationStatus computationStatus;
            Object responseObject;
            block28: {
                logger.debug("GetComputationStatus(): ComputationId=" + computationId);
                wpsClient = this.createWPSClientSession();
                wpsClient.connectForMonitoring(this.wpsProcessingServlet);
                responseObject = null;
                if (computationId == null || computationId.getUrlId() == null || computationId.getUrlId().isEmpty()) {
                    throw new ServiceException("Process Location is null!");
                }
                computationStatus = null;
                try {
                    Object statusType;
                    responseObject = wpsClient.executeViaGET(computationId.getUrlId(), "");
                    logger.debug("ComputationStatus ResponseObject: " + responseObject);
                    if (!(responseObject instanceof ExecuteResponseDocumentImpl)) break block28;
                    if (((ExecuteResponseDocumentImpl)responseObject).getExecuteResponse() == null) {
                        logger.debug("WPS FAILURE: ExecuteResponse is null");
                        computationStatus = new ComputationStatus(ComputationStatus.Status.FAILED, 100.0);
                    } else {
                        statusType = ((ExecuteResponseDocumentImpl)responseObject).getExecuteResponse().getStatus();
                        if (statusType == null) {
                            logger.debug("WPS FAILURE: Status Type is null");
                            computationStatus = null;
                        } else {
                            String failure;
                            String string = failure = statusType.getProcessFailed() == null ? null : statusType.getProcessFailed().getExceptionReport().toString();
                            if (failure != null && !failure.isEmpty()) {
                                logger.debug("WPS FAILURE: " + failure);
                                computationStatus = new ComputationStatus(new ServiceException(failure));
                            } else {
                                String paused;
                                String string2 = paused = statusType.getProcessPaused() == null ? null : statusType.getProcessPaused().getStringValue();
                                if (paused != null && !paused.isEmpty()) {
                                    logger.debug("WPS PAUSED: " + paused);
                                    computationStatus = new ComputationStatus(new ServiceException(paused));
                                } else {
                                    String success;
                                    String string3 = success = statusType.getProcessSucceeded() == null ? null : statusType.getProcessSucceeded();
                                    if (success != null && !success.isEmpty()) {
                                        logger.debug("WPS SUCCESS");
                                        computationStatus = new ComputationStatus(ComputationStatus.Status.COMPLETE, 100.0);
                                    } else {
                                        String accepted;
                                        String string4 = accepted = statusType.getProcessAccepted() == null ? null : statusType.getProcessAccepted();
                                        if (accepted != null && !accepted.isEmpty()) {
                                            logger.debug("WPS ACCEPTED");
                                            computationStatus = new ComputationStatus(ComputationStatus.Status.ACCEPTED, 0.0);
                                        } else {
                                            int status;
                                            int n = status = statusType.getProcessStarted() == null ? -1 : statusType.getProcessStarted().getPercentCompleted();
                                            if (status >= 0) {
                                                Float statusd = Float.valueOf(status);
                                                try {
                                                    statusd = Float.valueOf(Float.parseFloat(statusType.getProcessStarted().getStringValue()));
                                                }
                                                catch (Exception e) {
                                                    logger.debug(e.getLocalizedMessage());
                                                }
                                                logger.debug("WPS STATUS:" + statusd);
                                                computationStatus = new ComputationStatus(ComputationStatus.Status.RUNNING, statusd.floatValue());
                                            } else if (status == -1) {
                                                logger.debug("WPS STATUS: Computation cancelled, " + statusType.getProcessStarted());
                                                computationStatus = new ComputationStatus(ComputationStatus.Status.CANCELLED, -1.0);
                                            } else {
                                                logger.debug("WPS STATUS: Not Started, " + statusType.getProcessStarted());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    logger.debug("ComputationStatus: " + computationStatus);
                    statusType = computationStatus;
                    return statusType;
                }
                catch (Throwable e) {
                    logger.error("WPS FAILURE: " + e.getLocalizedMessage());
                    e.printStackTrace();
                    ComputationStatus computationStatus2 = computationStatus = new ComputationStatus(ComputationStatus.Status.FAILED, 100.0);
                    return computationStatus2;
                }
            }
            logger.error("Error in ResponceObject: " + responseObject);
            logger.error("WPS FAILURE: ");
            ComputationStatus statusType = computationStatus = new ComputationStatus(ComputationStatus.Status.FAILED, 100.0);
            return statusType;
        }
        catch (Throwable e) {
            logger.error("MonitorProcess: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
        finally {
            wpsClient.disconnect(this.wpsProcessingServlet);
        }
    }

    @Override
    public OutputData getOutputDataByComputationId(ComputationId computationId) throws ServiceException {
        LinkedHashMap<String, Resource> resources = this.retrieveOutput(computationId);
        MapResource mapResource = new MapResource("mapResource", "Resources", "Resources", resources);
        OutputData outputData = new OutputData(computationId, mapResource);
        return outputData;
    }

    private LinkedHashMap<String, Resource> retrieveOutput(ComputationId computationId) throws ServiceException {
        LinkedHashMap<String, Resource> outputResource = new LinkedHashMap<String, Resource>();
        LinkedHashMap<String, Parameter> outputParameters = new LinkedHashMap<String, Parameter>();
        ProcessInformations processInformations = this.runningProcess.get(computationId);
        if (processInformations != null && processInformations.getOutputs() != null) {
            for (OutputDescriptionType outputDesc : processInformations.getOutputs()) {
                Parameter outputParameter = WPS2DM.convert2DMType(outputDesc);
                logger.debug("OutputParameter: " + outputParameter);
                outputParameters.put(outputParameter.getName(), outputParameter);
            }
        }
        this.retrieveProcessOutput(computationId.getUrlId(), outputParameters, outputResource);
        return outputResource;
    }

    private void retrieveProcessOutput(String processLocation, Map<String, Parameter> outputParameters, Map<String, Resource> outputResource) throws ServiceException {
        OutputDataType[] outputData;
        ExecuteResponseDocument.ExecuteResponse.ProcessOutputs outs = this.retrieveProcessResult(processLocation);
        logger.debug("Process Executed");
        if (outs == null) {
            throw new ServiceException("Error during the execution of the WPS process: returned an empty document");
        }
        for (OutputDataType out : outputData = outs.getOutputArray()) {
            ObjectResource resource;
            String outputID = out.getIdentifier().getStringValue();
            String value = "";
            if (out.getData().isSetLiteralData()) {
                value = out.getData().getLiteralData().getStringValue();
                Parameter paramLiteral = outputParameters.get(outputID);
                if (paramLiteral == null) continue;
                paramLiteral.setValue(value);
                logger.debug("Assigning value: " + value + " to output named: " + outputID);
                resource = new ObjectResource(outputID, paramLiteral.getName(), paramLiteral.getDescription(), paramLiteral.getValue());
                outputResource.put(outputID, resource);
                continue;
            }
            if (out.getData().isSetComplexData()) {
                if (out.getReference() != null) {
                    value = out.getReference().getHref();
                    Parameter paramComplexData = outputParameters.get(outputID);
                    if (paramComplexData != null) {
                        paramComplexData.setValue(value);
                        logger.debug("Assigning value: " + value + " to output named: " + outputID);
                        resource = new ObjectResource(outputID, paramComplexData.getName(), paramComplexData.getDescription(), paramComplexData.getValue());
                        outputResource.put(outputID, resource);
                    }
                } else {
                    outputParameters.remove(outputID);
                }
                ComplexDataType cdt = out.getData().getComplexData();
                LinkedHashMap<String, ResponseWPS> urls = SClient4WPS.retrieveURLsFromWPSResponse(cdt);
                block12: for (String key : urls.keySet()) {
                    Resource resource2;
                    logger.debug("Adding OBJ:" + key);
                    ResponseWPS responseWPS = urls.get(key);
                    ObjectParameter objP = new ObjectParameter(key, responseWPS.getDescription(), String.class.getName(), " ");
                    objP.setValue(responseWPS.getData());
                    logger.debug("ObjectParameter: " + objP);
                    outputParameters.put(key, objP);
                    if (responseWPS == null || responseWPS.getMimeType() == null) continue;
                    switch (responseWPS.getMimeType()) {
                        case "image/bmp": 
                        case "image/gif": 
                        case "image/jpeg": 
                        case "image/png": {
                            resource2 = new ImageResource(key, responseWPS.getDescription(), responseWPS.getDescription(), responseWPS.getData(), responseWPS.getMimeType());
                            outputResource.put(key, resource2);
                            continue block12;
                        }
                        case "text/csv": {
                            if (responseWPS.getData() != null && !responseWPS.getData().isEmpty()) {
                                if (responseWPS.getData().startsWith("http:") || responseWPS.getData().startsWith("https:") || responseWPS.getData().startsWith("smp:")) {
                                    resource2 = new FileResource(key, responseWPS.getDescription(), responseWPS.getDescription(), responseWPS.getData(), responseWPS.getMimeType());
                                    outputResource.put(key, resource2);
                                    continue block12;
                                }
                                resource2 = new ObjectResource(key, responseWPS.getDescription(), responseWPS.getDescription(), responseWPS.getData());
                                outputResource.put(key, resource2);
                                continue block12;
                            }
                            resource2 = new ObjectResource(key, responseWPS.getDescription(), responseWPS.getDescription(), responseWPS.getData());
                            outputResource.put(key, resource2);
                            continue block12;
                        }
                    }
                    if (responseWPS.getData() != null && !responseWPS.getData().isEmpty()) {
                        if (responseWPS.getData().startsWith("http:") || responseWPS.getData().startsWith("https:") || responseWPS.getData().startsWith("smp:")) {
                            resource2 = new FileResource(key, responseWPS.getDescription(), responseWPS.getDescription(), responseWPS.getData(), responseWPS.getMimeType());
                            outputResource.put(key, resource2);
                            continue;
                        }
                        resource2 = new ObjectResource(key, responseWPS.getDescription(), responseWPS.getDescription(), responseWPS.getData());
                        outputResource.put(key, resource2);
                        continue;
                    }
                    resource2 = new ObjectResource(key, responseWPS.getDescription(), responseWPS.getDescription(), responseWPS.getData());
                    outputResource.put(key, resource2);
                }
                continue;
            }
            value = out.getData().getLiteralData().getStringValue();
        }
    }

    @Override
    public String cancelComputation(ComputationId computationId) throws ServiceException {
        SClient4WPSSession wpsClient = null;
        try {
            String result;
            wpsClient = this.createWPSClientSession();
            String string = result = wpsClient.cancelComputation(this.wpsCancelComputationServlet, computationId.getId());
            return string;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
        finally {
            if (wpsClient != null) {
                wpsClient.disconnect(this.wpsProcessingServlet);
            }
        }
    }

    @Override
    public ComputationId resubmitComputation(Map<String, String> computationProperties) throws ServiceException {
        ProcessInformations processInformations;
        if (computationProperties == null || computationProperties.isEmpty()) {
            throw new ServiceException("Invalid computation properties: " + computationProperties);
        }
        try {
            processInformations = this.describeProcess(computationProperties.get("operator_id"));
        }
        catch (Throwable e) {
            logger.error("GetParameters: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
        LinkedHashMap<String, Parameter> inputParameters = new LinkedHashMap<String, Parameter>();
        for (InputDescriptionType inputDesc : processInformations.getInputs()) {
            Parameter inputParameter = WPS2DM.convert2DMType(inputDesc);
            logger.debug("InputParameter: " + inputParameter);
            inputParameters.put(inputParameter.getName(), inputParameter);
        }
        LinkedHashMap<String, String> userInputs = new LinkedHashMap<String, String>();
        for (String key : computationProperties.keySet()) {
            int inputSeparatorIndex;
            String inputKey;
            if (!key.startsWith("input") || (inputKey = key.substring((inputSeparatorIndex = key.indexOf("_")) + 1)).compareToIgnoreCase("user.name") == 0 || inputKey.compareToIgnoreCase("scope") == 0) continue;
            userInputs.put(inputKey, computationProperties.get(key));
            logger.debug("UserInputs[key=" + inputKey + ", value=" + computationProperties.get(key) + "]");
        }
        if (userInputs.isEmpty()) {
            logger.error("Attention no inputs parameters retrieved for this computation: " + computationProperties);
            throw new ServiceException("Attention no inputs parameters retrieved for this computation: " + computationProperties);
        }
        LinkedHashMap<String, String> equivalentRequestMap = new LinkedHashMap<String, String>();
        String processUrl = this.compute(processInformations, userInputs, inputParameters, equivalentRequestMap);
        logger.debug("Stated Computation ProcessLocation:" + processUrl);
        int idIndex = processUrl.lastIndexOf("?id=");
        if (idIndex <= -1) {
            logger.error("Invalid processLocation: " + processUrl);
            throw new ServiceException("Invalid processLocation: " + processUrl);
        }
        String id = processUrl.substring(idIndex + 4, processUrl.length());
        String equivalentRequest = this.extractEquivalentRequestForResubmit(computationProperties, equivalentRequestMap);
        ComputationId computationId = new ComputationId(id, processUrl, computationProperties.get("operator_id"), computationProperties.get("operator_name"), equivalentRequest);
        logger.debug("ComputationId: " + computationId);
        this.runningProcess.put(computationId, processInformations);
        return computationId;
    }

    private String extractEquivalentRequestForResubmit(Map<String, String> computationProperties, LinkedHashMap<String, String> equivalentRequestMap) {
        String equivalentRequest = this.wpsProcessingServlet + "?" + "request=Execute&service=WPS&Version=1.0.0&gcube-token=" + this.wpsToken + "&lang=en-US&Identifier=" + computationProperties.get("operator_id") + "&DataInputs=";
        for (String key : equivalentRequestMap.keySet()) {
            String keyEncoded = "";
            try {
                keyEncoded = URLEncoder.encode(key, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Error in equivalent request creation: Unsupported Encoding for parameter=" + key, (Throwable)e);
                break;
            }
            String valueEncoded = "";
            try {
                valueEncoded = URLEncoder.encode(equivalentRequestMap.get(key), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Error in equivalent request creation: Unsupported Encoding for value=" + equivalentRequestMap.get(key) + " of parameter=" + key, (Throwable)e);
                break;
            }
            equivalentRequest = equivalentRequest + keyEncoded + "=" + valueEncoded + ";";
        }
        return equivalentRequest;
    }

    @Override
    public ComputationData getComputationDataByComputationProperties(Map<String, String> computationProperties) throws ServiceException {
        try {
            if (computationProperties == null || computationProperties.isEmpty()) {
                throw new Exception("Invalid computation properties: " + computationProperties);
            }
            String compId = computationProperties.get("computation_id");
            String operatorId = computationProperties.get("operator_id");
            String operatorName = computationProperties.get("operator_name");
            String operatorDescritpion = computationProperties.get("operator_description");
            String vre = computationProperties.get("VRE");
            String startDate = computationProperties.get("start_date");
            String endDate = computationProperties.get("end_date");
            String status = computationProperties.get("status");
            String executionType = computationProperties.get("execution_type");
            ComputationId computationId = new ComputationId();
            computationId.setId(compId);
            computationId.setOperatorId(operatorId);
            computationId.setOperatorName(operatorName);
            ArrayList<ComputationItemPropertiesValue> inputParametersAsProperties = new ArrayList<ComputationItemPropertiesValue>();
            ArrayList<ComputationItemPropertiesValue> outputParametersAsProperties = new ArrayList<ComputationItemPropertiesValue>();
            for (String key : computationProperties.keySet()) {
                Integer order;
                if (key == null) continue;
                if (key.startsWith("input")) {
                    int inputSeparatorIndex = key.indexOf("_");
                    String inputKey = key.substring(inputSeparatorIndex + 1);
                    if (inputKey.compareToIgnoreCase("user.name") == 0 || inputKey.compareToIgnoreCase("scope") == 0) continue;
                    String inputOrder = key.substring(5, inputSeparatorIndex);
                    try {
                        order = Integer.parseInt(inputOrder);
                    }
                    catch (NumberFormatException e) {
                        order = 0;
                    }
                    ComputationItemPropertiesValue inputProps = new ComputationItemPropertiesValue(order, inputKey, computationProperties.get(key));
                    inputParametersAsProperties.add(inputProps);
                    continue;
                }
                if (!key.startsWith("output")) continue;
                int outputSeparatorIndex = key.indexOf("_");
                String outputKey = key.substring(outputSeparatorIndex + 1);
                String outputOrder = key.substring(6, outputSeparatorIndex);
                try {
                    order = Integer.parseInt(outputOrder);
                }
                catch (NumberFormatException e) {
                    order = 0;
                }
                ComputationItemPropertiesValue outputProps = new ComputationItemPropertiesValue(order, outputKey, computationProperties.get(key));
                outputParametersAsProperties.add(outputProps);
            }
            Collections.sort(inputParametersAsProperties);
            Collections.sort(outputParametersAsProperties);
            ComputationValueBuilder computationValueBuilder = new ComputationValueBuilder(inputParametersAsProperties);
            LinkedHashMap<String, ComputationValue> inputParameters = computationValueBuilder.create();
            computationValueBuilder = new ComputationValueBuilder(outputParametersAsProperties);
            LinkedHashMap<String, ComputationValue> outputParameters = computationValueBuilder.create();
            logger.debug("inputParameters: " + inputParameters);
            logger.debug("outputParameters: " + outputParameters);
            ComputationData computationData = new ComputationData(computationId, inputParameters, outputParameters, operatorDescritpion, startDate, endDate, status, executionType, vre);
            logger.debug("ComputationData: " + computationData);
            return computationData;
        }
        catch (ServiceException e) {
            logger.error("Error in getComutationDataByComputationProperties: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            logger.error("Error in getComutationDataByComputationProperties: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public String toString() {
        return "DataMiner WPS Client";
    }
}

