/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.dataminermanagercl.server.dmservice.wps.computationsvalue;

import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationItemPropertiesValue;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationValue;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationValueFile;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationValueFileList;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationValueImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputationValueBuilder {
    private static Logger logger = LoggerFactory.getLogger(ComputationValueBuilder.class);
    private ArrayList<ComputationItemPropertiesValue> valueParameters;
    private LinkedHashMap<String, ComputationValue> computationsValueParameters;

    public ComputationValueBuilder(ArrayList<ComputationItemPropertiesValue> valueParameters) {
        this.valueParameters = valueParameters;
    }

    public LinkedHashMap<String, ComputationValue> create() {
        this.computationsValueParameters = new LinkedHashMap();
        if (this.valueParameters != null && !this.valueParameters.isEmpty()) {
            for (ComputationItemPropertiesValue valueParameter : this.valueParameters) {
                String value = valueParameter.getValue();
                if (value != null && !value.isEmpty() && value.startsWith("http")) {
                    if (value.contains("|")) {
                        ComputationValue valueFileList = this.createComputationValueFileList(value);
                        this.computationsValueParameters.put(valueParameter.getKey(), valueFileList);
                        continue;
                    }
                    ComputationValue computationValue = this.retrieveFileName(value);
                    this.computationsValueParameters.put(valueParameter.getKey(), computationValue);
                    continue;
                }
                ComputationValue valueString = new ComputationValue(value);
                this.computationsValueParameters.put(valueParameter.getKey(), valueString);
            }
        }
        logger.debug("CompuatationsValues: " + this.computationsValueParameters);
        return this.computationsValueParameters;
    }

    private ComputationValue createComputationValueFileList(String value) {
        ComputationValue computationValue;
        int indexSeparator;
        ArrayList<ComputationValue> fileList = new ArrayList<ComputationValue>();
        while ((indexSeparator = value.indexOf("|")) != -1) {
            String file = value.substring(0, indexSeparator);
            value = value.substring(indexSeparator + 1);
            computationValue = this.retrieveFileName(file);
            fileList.add(computationValue);
        }
        computationValue = this.retrieveFileName(value);
        fileList.add(computationValue);
        ComputationValueFileList computationValueFileList = new ComputationValueFileList(fileList, "|");
        return computationValueFileList;
    }

    private ComputationValue retrieveFileName(String value) {
        URLConnection conn = null;
        logger.debug("Retrieve File Header from Storage for value: " + value);
        try {
            URL url = new URL(value);
            conn = url.openConnection();
            return this.extractFileName(conn, value);
        }
        catch (Throwable e) {
            logger.error("Retrieve File Name: " + e.getLocalizedMessage());
            e.printStackTrace();
            return new ComputationValueFile(value, null, null);
        }
    }

    private ComputationValue extractFileName(URLConnection conn, String value) {
        ComputationValue computationValue = null;
        String fileName = null;
        String mimeType = null;
        logger.debug("Connection-Header: " + conn.getHeaderFields());
        String contentDisposition = conn.getHeaderField("Content-Disposition");
        if (contentDisposition == null) {
            Map<String, List<String>> headerFields = conn.getHeaderFields();
            boolean found = false;
            for (String key : headerFields.keySet()) {
                List<String> headerField = headerFields.get(key);
                for (String fieldValue : headerField) {
                    if (!fieldValue.toLowerCase().contains("filename=")) continue;
                    contentDisposition = fieldValue;
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
        }
        logger.debug("Content-Disposition: " + contentDisposition);
        if (contentDisposition != null && contentDisposition.indexOf("=") != -1 && (fileName = contentDisposition.split("=")[1]) != null && !fileName.isEmpty()) {
            if (fileName.startsWith("\"")) {
                fileName = fileName.substring(1);
            }
            if (fileName.endsWith("\"")) {
                fileName = fileName.substring(0, fileName.length() - 1);
            }
        }
        computationValue = (mimeType = conn.getContentType()) != null && mimeType.compareToIgnoreCase("image/png") == 0 || fileName != null && fileName.endsWith(".png") ? new ComputationValueImage(value, fileName, mimeType) : new ComputationValueFile(value, fileName, mimeType);
        return computationValue;
    }
}

