/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.sdmx.datasource.tabman.querymanager.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gcube.data.analysis.sdmx.datasource.data.BasicQuery;
import org.gcube.data.analysis.sdmx.datasource.tabman.querymanager.exceptions.InvalidInformationSystemDataException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.GreaterOrEquals;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.LessOrEquals;
import org.gcube.data.analysis.tabulardata.expression.logical.And;
import org.gcube.data.analysis.tabulardata.expression.logical.Or;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDInteger;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.select.QueryColumn;
import org.gcube.data.analysis.tabulardata.query.parameters.select.QuerySelect;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.datapublishing.sdmx.DataInformationProvider;
import org.gcube.datapublishing.sdmx.model.TableIdentificators;
import org.sdmxsource.sdmx.api.model.format.DataQueryFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabmanQuery
extends BasicQuery
implements DataQueryFormat<TabmanQuery> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private QueryFilter filter = null;
    private QuerySelect querySelectFilter;
    private TableId tableId;

    public void initQuery(TabularDataService service, boolean lastTable) throws NoSuchTabularResourceException, NoSuchTableException, InvalidInformationSystemDataException {
        this.logger.debug("Loading table identificators from the Information System");
        TableIdentificators tableIdentificators = this.getTableIdentificators(this.dataFlowAgency, this.dataFlowId, this.dataFlowVersion);
        if (tableIdentificators == null) {
            this.logger.error("Tabular resource not found for the data flow");
            throw new InvalidInformationSystemDataException("Tabular resource not found for the data flow");
        }
        Table table = null;
        if (lastTable) {
            table = service.getLastTable(new TabularResourceId(tableIdentificators.getTabularResourceID()));
            if (table == null) {
                this.logger.error("Tablular resource not found " + tableIdentificators.getTabularResourceIDString());
                throw new NoSuchTabularResourceException(tableIdentificators.getTabularResourceID());
            }
        } else {
            table = service.getTable(new TableId(tableIdentificators.getTableID()));
            if (table == null) {
                this.logger.error("Table not found " + tableIdentificators.getTableIDString());
                throw new NoSuchTableException(new TableId(tableIdentificators.getTableID()));
            }
        }
        this.tableId = table.getId();
        this.logger.debug("Table  found: id " + this.tableId.getValue());
        List<QueryColumn> queryColumns = this.getColumns(table.getColumns());
        if (queryColumns.size() > 0) {
            this.logger.debug("Generating query select filter");
            this.querySelectFilter = new QuerySelect(queryColumns);
        } else {
            this.logger.debug("No query select filter generated");
        }
        this.filter = this.buildQueryFilter();
        this.logger.debug("Query generated");
    }

    private TableIdentificators getTableIdentificators(String dataFlowAgency, String dataFlowId, String dataFlowVersion) {
        this.logger.debug("Getting table identificators for agency " + dataFlowAgency + " data flow " + dataFlowId + " version " + dataFlowVersion);
        String dataFlowKey = DataInformationProvider.getDataFlowKey((String)dataFlowAgency, (String)dataFlowId, (String)dataFlowVersion);
        this.logger.debug("Data flow key " + dataFlowKey);
        TableIdentificators identificators = DataInformationProvider.getInstance().getTableId(dataFlowKey);
        this.logger.debug("Operation completed with result " + identificators);
        return identificators;
    }

    private List<QueryColumn> getColumns(List<Column> tableColumns) {
        this.logger.debug("Generating the list of requested columns");
        ArrayList<QueryColumn> response = new ArrayList<QueryColumn>();
        List columnIds = this.getColumnIds();
        for (Column column : tableColumns) {
            ColumnLocalId localId = column.getLocalId();
            String localIdString = localId.getValue();
            this.logger.debug("Column local id " + localIdString);
            if (columnIds.remove(localIdString)) {
                this.logger.debug("Element found");
                response.add(new QueryColumn(localId));
                continue;
            }
            this.logger.warn("Element " + localIdString + " not found on the registry: extra column?");
        }
        if (!columnIds.isEmpty()) {
            this.logger.warn("At least one column on the registry has not a corresponding data column!");
        }
        return response;
    }

    private Expression buildSingleColumnExpression(String columnId, Set<String> values) {
        if (values.size() == 1) {
            this.logger.debug("Generating single value expression");
            return this.generateEqualExpression(columnId, values.iterator().next());
        }
        if (values.size() > 1) {
            this.logger.debug("Generating or expression");
            LinkedList<Expression> equalsList = new LinkedList<Expression>();
            Iterator<String> valuesIterator = values.iterator();
            while (valuesIterator.hasNext()) {
                equalsList.add(this.generateEqualExpression(columnId, valuesIterator.next()));
            }
            return new Or(equalsList);
        }
        return null;
    }

    private QueryFilter buildQueryFilter() {
        this.logger.debug("Generating query filter");
        QueryFilter response = null;
        ArrayList<Expression> andExpressionsList = new ArrayList<Expression>();
        if (!this.parametersMap.isEmpty()) {
            for (String columnId : this.parametersMap.keySet()) {
                Set values = (Set)this.parametersMap.get(columnId);
                andExpressionsList.add(this.buildSingleColumnExpression(columnId, values));
            }
        }
        if (this.timeIntervalMin != -1) {
            andExpressionsList.add(this.generateNotEqualExpression(this.timeDimension.getId(), this.timeIntervalMin, true));
        }
        if (this.timeIntervalMax != -1) {
            andExpressionsList.add(this.generateNotEqualExpression(this.timeDimension.getId(), this.timeIntervalMax, false));
        }
        if (andExpressionsList.size() == 1) {
            response = new QueryFilter((Expression)andExpressionsList.get(0));
        } else if (andExpressionsList.size() > 1) {
            response = new QueryFilter((Expression)new And(andExpressionsList));
        }
        return response;
    }

    private Expression generateEqualExpression(String columnId, String queryParameter) {
        this.logger.debug("Generating expression for " + columnId + " with parameter " + queryParameter);
        ColumnReference leftArgument = new ColumnReference(this.tableId, new ColumnLocalId(columnId));
        TDText rightArgument = new TDText(queryParameter);
        return new Equals((Expression)leftArgument, (Expression)rightArgument);
    }

    private Expression generateNotEqualExpression(String columnId, int queryParameter, boolean greaterOrEqual) {
        this.logger.debug("Generating expression for " + columnId + " with parameter " + queryParameter + " greater or equal flag " + greaterOrEqual);
        ColumnReference leftArgument = new ColumnReference(this.tableId, new ColumnLocalId(columnId));
        TDInteger rightArgument = new TDInteger(Integer.valueOf(queryParameter));
        return greaterOrEqual ? new GreaterOrEquals((Expression)leftArgument, (Expression)rightArgument) : new LessOrEquals((Expression)leftArgument, (Expression)rightArgument);
    }

    public QueryFilter getFilter() {
        return this.filter;
    }

    public QuerySelect getQuerySelectFilter() {
        return this.querySelectFilter;
    }

    public TableId getTableId() {
        return this.tableId;
    }
}

