/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.sdmx.datasource.tabman.querymanager.json;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JSonModel {
    protected Map<String, JSonModel> dataMap;
    protected Map<String, List<Object>> arrayDataMap;
    protected Map<String, String> mainMap;
    private Logger logger = LoggerFactory.getLogger(JSonModel.class);

    public JSonModel() {
        this.dataMap = new HashMap<String, JSonModel>();
        this.arrayDataMap = new HashMap<String, List<Object>>();
        this.mainMap = new HashMap<String, String>();
    }

    protected abstract int checkKey(String var1);

    protected abstract JSonModel generateInternalObject(String var1);

    protected abstract JSonModel generateInternalArrayObject(String var1, int var2);

    public void fromJson(byte[] json) throws Exception {
        JsonFactory f = new JsonFactory();
        JsonParser jp = f.createJsonParser(json);
        jp.nextToken();
        this.fromJson(jp);
    }

    protected void fromJson(JsonParser jp) throws Exception {
        JsonToken tolkein = jp.getCurrentToken();
        while ((tolkein = jp.nextToken()) != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            tolkein = jp.nextToken();
            this.logger.debug("Parsing key " + key);
            int type = this.checkKey(key);
            this.logger.debug("Key type " + Integer.toBinaryString(type));
            if (tolkein == JsonToken.START_OBJECT) {
                if (!this.keyTypeComparison(type, KeyType.OBJECT.getValue())) continue;
                this.logger.debug("Valid object key " + key);
                JSonModel internalModel = this.generateInternalObject(key);
                internalModel.fromJson(jp);
                this.dataMap.put(key, internalModel);
                continue;
            }
            if (tolkein == JsonToken.START_ARRAY) {
                this.logger.debug("Array");
                ArrayList<Object> modelArray = new ArrayList<Object>();
                int arrayElement = 0;
                while ((tolkein = jp.nextToken()) != JsonToken.END_ARRAY) {
                    if (this.keyTypeComparison(type, KeyType.OBJECT_ARRAY.getValue())) {
                        this.logger.debug("Array of objects");
                        this.logger.debug("Valid array key " + key);
                        JSonModel internalModel = this.generateInternalArrayObject(key, arrayElement);
                        internalModel.fromJson(jp);
                        modelArray.add(internalModel);
                        ++arrayElement;
                    } else if (this.keyTypeComparison(type, KeyType.STRING_ARRAY.getValue())) {
                        this.logger.debug("Array of strings");
                        this.logger.debug("Valid array key " + key);
                        String value = jp.getText();
                        this.logger.debug("Value " + value);
                        modelArray.add(value);
                        ++arrayElement;
                    }
                    if (modelArray.isEmpty()) continue;
                    this.arrayDataMap.put(key, modelArray);
                }
                continue;
            }
            if (this.keyTypeComparison(type, KeyType.STRING.getValue())) {
                this.logger.debug("Valid key " + key);
                String value = jp.getText();
                this.mainMap.put(key, value);
                continue;
            }
            this.logger.debug("Invalid key " + key);
        }
    }

    private boolean keyTypeComparison(int keyType, int keyMask) {
        return (keyType & keyMask) == keyMask;
    }

    public String toJson() throws Exception {
        StringWriter outBuffer = new StringWriter();
        JsonFactory f = new JsonFactory();
        JsonGenerator g = f.createJsonGenerator((Writer)outBuffer);
        g.useDefaultPrettyPrinter();
        g.writeStartObject();
        this.toJson(g);
        g.writeEndObject();
        g.flush();
        return outBuffer.toString();
    }

    protected void toJson(JsonGenerator g) throws Exception {
        for (String key : this.mainMap.keySet()) {
            String value = this.mainMap.get(key);
            g.writeStringField(key, value);
        }
        for (String key : this.dataMap.keySet()) {
            JSonModel value = this.dataMap.get(key);
            g.writeObjectFieldStart(key);
            value.toJson(g);
            g.writeEndObject();
        }
        for (String key : this.arrayDataMap.keySet()) {
            List<Object> value = this.arrayDataMap.get(key);
            g.writeArrayFieldStart(key);
            this.logger.debug("Array element key " + key);
            for (Object model : value) {
                if (model instanceof JSonModel) {
                    this.logger.debug("Object element");
                    g.writeStartObject();
                    ((JSonModel)model).toJson(g);
                    g.writeEndObject();
                    continue;
                }
                if (model instanceof String) {
                    this.logger.debug("String element");
                    g.writeString((String)model);
                    continue;
                }
                this.logger.debug("Invalid element " + model.getClass().toString());
            }
            g.writeEndArray();
        }
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (Exception e) {
            this.logger.error("problem in converting data into JSon string " + e);
            return "";
        }
    }

    public static enum KeyType {
        STRING(1),
        STRING_ARRAY(2),
        OBJECT(4),
        OBJECT_ARRAY(8);

        private int type;

        private KeyType(int type) {
            this.type = type;
        }

        public int getValue() {
            return this.type;
        }
    }
}

