package org.gcube.data.analysis.statisticalmanager.proxies;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Logger;

import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;

import org.apache.axis.message.addressing.EndpointReferenceType;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.Callback;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.clients.gcore.Utils;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.stubs.ComputationFactoryPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.ComputationPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithmsRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputations;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationsRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameters;
import org.gcube.data.analysis.statisticalmanager.stubs.SMTypeParameter;
import org.gcube.data.analysis.statisticalmanager.wrapper.RSWrapper;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMOperation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMOperationInfo;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMPagedRequest;

public class StatisticalManagerDefaultFactory implements
		StatisticalManagerFactory {
	public static GCUBELog logger= new GCUBELog(StatisticalManagerDefaultFactory.class);
	private final AsyncProxyDelegate<ComputationFactoryPortType> delegate;

	public StatisticalManagerDefaultFactory(
			ProxyDelegate<ComputationFactoryPortType> delegate) {
		this.delegate = new AsyncProxyDelegate<ComputationFactoryPortType>(
				delegate);
	}

	private W3CEndpointReference getEPRComputationResource(String computationId) {

		W3CEndpointReference epr = null;
		try {
			GCUBEScope scope = GCUBEScope
					.getScope(ScopeProvider.instance.get());
			ISClient client = GHNContext.getImplementation(ISClient.class);
			WSResourceQuery wsquery = client.getQuery(WSResourceQuery.class);
			wsquery.addAtomicConditions(new AtomicCondition("//gc:ServiceName",
					"statistical-manager-gcubews"));

			EndpointReferenceType ert = null;
			for (RPDocument d : client.execute(wsquery, scope)) {
				for (String value : d.evaluate("//computation/text()")) {
					if (computationId.equals(value)) {
						ert = d.getEndpoint();
						break;
					}
				}
				if (ert != null) {
					epr = Utils.convert(ert);
					break;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return epr;

	}

	@Override
	public SMListGroupedAlgorithms getAlgorithms(
			SMTypeParameter... typeParameters) {

		final SMAlgorithmsRequest request = new SMAlgorithmsRequest(
				typeParameters);

		Call<ComputationFactoryPortType, SMListGroupedAlgorithms> call = new Call<ComputationFactoryPortType, SMListGroupedAlgorithms>() {
			@Override
			public SMListGroupedAlgorithms call(
					ComputationFactoryPortType endpoint) throws Exception {

				return endpoint.getAlgorithms(request);
			}
		};

		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public SMOperationInfo getComputationInfo(String computationId, String user) {

		W3CEndpointReference epr = getEPRComputationResource(computationId);

		if (epr == null) {
			SMComputation computation = getComputation(computationId);
			SMOperationInfo info = new SMOperationInfo();
			int index = computation.getOperationStatus();
			info.setStatus(index);
			info.setPercentage(String.valueOf(0));
			switch (SMOperationStatus.values()[index]) {
			case COMPLETED:
				info.setPercentage(String.valueOf(100));
				break;
			case FAILED:
				info.setPercentage(String.valueOf(100));
				break;
			default:
				break;
			}

			return info;
		}

		StatisticalManagerService service = StatisticalManagerDSL.stateful()
				.at(epr).build();

		return service.getComputationInfo(computationId);
	}

	@Override
	public SMParameters getAlgorithmParameters(final String algorithm) {

		Call<ComputationFactoryPortType, SMParameters> call = new Call<ComputationFactoryPortType, SMParameters>() {

			@Override
			public SMParameters call(ComputationFactoryPortType endpoint)
					throws Exception {
				return endpoint.getAlgorithmParameters(algorithm);
			};
		};

		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public SMComputations getComputations(final String user,
			final SMTypeParameter... typeParameters) {

		Call<ComputationFactoryPortType, SMComputations> call = new Call<ComputationFactoryPortType, SMComputations>() {
			@Override
			public SMComputations call(ComputationFactoryPortType endpoint)
					throws Exception {

				SMComputationsRequest request = new SMComputationsRequest();
				request.setUser(user);
				request.setParameters(typeParameters);

				return endpoint.getComputations(request);
			}
		};

		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public String executeComputation(
			final SMComputationRequest requestComputation) {

		Call<ComputationFactoryPortType, String> call = new Call<ComputationFactoryPortType, String>() {

			@Override
			public String call(ComputationFactoryPortType endpoint)
					throws Exception {
				return endpoint.executeComputation(requestComputation);
			}

		};

		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public SMComputation getComputation(final String computationId) {

		Call<ComputationFactoryPortType, SMComputation> call = new Call<ComputationFactoryPortType, SMComputation>() {

			@Override
			public SMComputation call(ComputationFactoryPortType endpoint)
					throws Exception {

				return endpoint.getComputation(computationId);
			}

		};

		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public void removeComputation(final String computationId) {

		W3CEndpointReference epr = getEPRComputationResource(computationId);

		if (epr == null) {

			Call<ComputationFactoryPortType, VOID> call = new Call<ComputationFactoryPortType, VOID>() {

				@Override
				public VOID call(ComputationFactoryPortType endpoint)
						throws Exception {

					return endpoint.removeComputation(computationId);
				}

			};

			// try {
			//
			// StatisticalManagerService service = StatisticalManagerDSL
			// .stateful().at(epr).build();
			// service.removeComputation(computationId);
			// delegate.make(call);
			// return;
			// } catch (Exception e) {
			// throw FaultDSL.again(e).asServiceException();
			// }
			try {

				StatisticalManagerService service = StatisticalManagerDSL
						.stateful().at(epr).build();
				service.removeComputation(computationId);

			} catch (Exception e) {
				StringWriter sw = new StringWriter();
				PrintWriter pw = new PrintWriter(sw);
				e.printStackTrace(pw);
				
				logger.trace(sw.toString());
				throw FaultDSL.again(e).asServiceException();

			}

		}

	}

	@Override
	public SMListGroupedAlgorithms getAlgorithmsUser(
			SMTypeParameter... typeParameters) {

		final SMAlgorithmsRequest request = new SMAlgorithmsRequest(
				typeParameters);

		Call<ComputationFactoryPortType, SMListGroupedAlgorithms> call = new Call<ComputationFactoryPortType, SMListGroupedAlgorithms>() {
			@Override
			public SMListGroupedAlgorithms call(
					ComputationFactoryPortType endpoint) throws Exception {

				return endpoint.getAlgorithmsUser(request);
			}
		};

		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public String resubmitComputation(final String computationId) {

		Call<ComputationFactoryPortType, String> call = new Call<ComputationFactoryPortType, String>() {

			@Override
			public String call(ComputationFactoryPortType endpoint)
					throws Exception {

				return endpoint.resubmitComputation(computationId);
			}

		};

		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}

	}

}
