package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import net.sf.csv4j.CSVFileProcessor;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

import static org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager.*;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;

public class CSVImporter {

	private static GCUBELog logger = new GCUBELog(CSVImporter.class);
	private File file;
	private boolean hasHeader;
	private String tableLabel;
	private String tableTemplate;
	private String delimiter;
	private char comment;
	
	public CSVImporter(File file, boolean hasHeader, String tableLabel,
			String tableTemplate, String delimiter, String comment) {
		this.file= file;
		this.hasHeader = hasHeader;
		this.tableLabel = tableLabel;
		this.tableTemplate = tableTemplate;
		this.delimiter = delimiter;
		if (comment!= null && !comment.isEmpty())
			this.comment = comment.charAt(0);
		else
			this.comment = '#';
	}
	
	public String toTabularData() throws Exception   {
		
		Connection conn = null;
		PreparedStatement createTable = null;
		String dbTableName = null;
		try {
			
			conn = DriverManager.getConnection(DataBaseManager.getUrlDB(),
					DataBaseManager.getUsername(), DataBaseManager.getPassword());
			conn.setAutoCommit(false);
			
			dbTableName = tableTemplate + "_ID" + UUID.randomUUID().toString().replace("-", "_");
			dbTableName = dbTableName.toLowerCase();
			
			String sql = null;
			
			
			if (tableTemplate.equals(TableTemplates.GENERIC.toString()))
				sql = getSqlStatmentCreateTable(dbTableName);
			else
				sql = String.format("create table %s (like %s)",
						dbTableName,
						tableTemplate);
			
			logger.debug("SQL create table: " + sql);
			
			createTable = conn.prepareStatement(sql);
			createTable.executeUpdate();			
			
			logger.debug("SQL string " + String.format("COPY %s FROM STDIN WITH DELIMITER '%s' %s  QUOTE '\"' ESCAPE '\\\\' ",
					dbTableName,delimiter,(hasHeader)?"CSV HEADER":"CSV"));
			
			CopyManager copyManager = new CopyManager((BaseConnection) conn);
			copyManager.copyIn(String.format("COPY %s FROM STDIN WITH DELIMITER '%s' %s QUOTE '\"' ESCAPE '\\\\' ",
					dbTableName,delimiter,(hasHeader)?"CSV HEADER":"CSV"), new FileInputStream(file));
	
			conn.commit();
			
		} catch (Exception e) {
			logger.error("CSV importer error :",e);
			rollback(conn);
			throw new Exception();
		} finally {
			closeStatement(createTable);
			closeConn(conn);
		}
		
		return dbTableName;
	}
	
	private String getSqlStatmentCreateTable(String dbTableName) throws Exception {
		
		CSVFileProcessor fp = new CSVFileProcessor();
		CSVLineProcessorGeneric lineProcessor = new CSVLineProcessorGeneric(delimiter);
		fp.setHasHeader(hasHeader);
		fp.setComment(comment);
		fp.processFile(file.getAbsolutePath(),lineProcessor);
		
		logger.debug("hasHeader " + hasHeader);
		logger.debug("comment" + comment);
		
		List<String> cols = lineProcessor.getColsName();
		if (!hasHeader) {
			cols = new ArrayList<String>();
			for (int i = 0; i < lineProcessor.getSqlType().size(); i ++) {
				cols.add("Field"+i);
			}			
		}
					
		String args = "";
		int i = 0;
		for (String colName : cols){
			args+=String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
		}
		String sql = String.format("CREATE TABLE %s ( %s )", dbTableName, args.substring(0, args.length() - 1));
		
		return sql;
	}
	
}
