package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;

import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;

public class CSVLineProcessorGeneric implements CSVLineProcessor {

		private boolean stop = true;
		private List<String> sqlTypes = new ArrayList<String>();
		private List<String> colNames = new ArrayList<String>();
		private String separator;
		
		
		private static final String colName = "FIELD";
		
		public CSVLineProcessorGeneric(String separator) {
			this.separator = separator;
		}
		
		@Override
		public boolean continueProcessing() {
			return stop;
		}

		@Override
		public void processDataLine(int arg0, List<String> fields) {
			// TODO Auto-generated method stub
			// use the data
			for ( final String fieldValue : fields ) {
				if (fieldValue != null) {
					
					for(String value : fieldValue.split(separator)) {
						
						ArrayList<String> values = new ArrayList<String>();
						values.add(value);
						
						String className = DataTypeRecognizer.guessType(values);
						String sqlType = null;
						if (String.class.getName().equals(className)) {
							sqlType = "varchar";
						}						
						if(Boolean.class.getName().equals(className)) {
							sqlType = "boolean";
						}		

						if(BigDecimal.class.getName().equals(className)) {
							sqlType = "double precision";
						}

						sqlTypes.add(sqlType);
					}
					
				} else {
					sqlTypes.add("varchar");
				}
			}
			stop = false;
		}

		@Override
		public void processHeaderLine(int arg0, List<String> fields) {	
			// do something with the list of header columns
			int index = 1;
			for ( final String fieldName : fields ) {		
				String[] values = fieldName.split(separator);
				for(String value : values) {
					colNames.add(value);
				}			
			}
		}
		
		public List<String> getColsName() {
			return colNames;
		}
		
		public List<String> getSqlType() {
			return sqlTypes;
		}
	   
};
	
