/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.SMFileManagerException;

public class FileManager {
    private static GCUBELog logger = new GCUBELog(FileManager.class);
    private static final String TMP_FOLDER = "tmp/";
    private static final String PERSISTENCE_FOLDER = "persistence/";
    private String tmpFolder;
    private String persistenceFolder;

    private String initializeFolder(String persistencePath) {
        File f = new File(persistencePath);
        if (!f.exists()) {
            logger.debug((Object)("Creating persistence folder " + persistencePath));
            f.mkdirs();
            try {
                Process proc = Runtime.getRuntime().exec("chmod -R 777 " + persistencePath);
                try {
                    proc.waitFor();
                }
                catch (InterruptedException e) {
                    int exitValue = proc.exitValue();
                    logger.debug((Object)("Permission execution exit value = " + exitValue));
                }
            }
            catch (IOException e) {
                logger.warn((Object)"Unexpected Exception", (Throwable)e);
            }
        }
        return persistencePath;
    }

    public FileManager(String persistenceFolder) {
        this.tmpFolder = String.valueOf(persistenceFolder) + File.separator + TMP_FOLDER;
        this.initializeFolder(this.tmpFolder);
        this.persistenceFolder = String.valueOf(persistenceFolder) + File.separator + PERSISTENCE_FOLDER;
        this.initializeFolder(this.persistenceFolder);
    }

    public String serializeObject(Object object, String fileExtension) throws SMFileManagerException {
        String fileName = String.valueOf(UUID.randomUUID().toString()) + fileExtension;
        String filePath = String.valueOf(this.tmpFolder) + fileName;
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(filePath);
                XStream xstream = new XStream();
                xstream.toXML(object, (OutputStream)fos);
            }
            catch (Exception e) {
                throw new SMFileManagerException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
        return filePath;
    }

    public String createFile(InputStream is) throws SMFileManagerException {
        try {
            String fileName = UUID.randomUUID().toString();
            File file = new File(String.valueOf(this.tmpFolder) + File.separator + fileName);
            FileOutputStream out = new FileOutputStream(file);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            is.close();
            out.flush();
            ((OutputStream)out).close();
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new SMFileManagerException(e.getMessage());
        }
    }
}

