/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.AccessPointDescriptor;
import org.gcube.data.analysis.statisticalmanager.persistence.DatabaseType;
import org.gcube.data.analysis.statisticalmanager.persistence.RuntimeResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBaseManager {
    private static Logger logger = LoggerFactory.getLogger(DataBaseManager.class);
    public static final String DRIVER = "org.postgresql.Driver";
    private static final ConcurrentHashMap<String, DataBaseManager> dbMap;
    private String url;
    private String username;
    private String password;
    private GenericObjectPool connectionPool;
    private DataSource dataSource;

    public static synchronized DataBaseManager get() throws StatisticalManagerException, Exception {
        String currentScope = ScopeProvider.instance.get();
        logger.trace("Getting DB under scope " + currentScope);
        if (!dbMap.contains(currentScope)) {
            AccessPointDescriptor desc = RuntimeResourceManager.getDatabaseProfile(DatabaseType.OPERATIONAL);
            logger.debug("Initiazlizing with " + desc + " under scope " + currentScope);
            dbMap.put(currentScope, new DataBaseManager(desc));
        }
        return dbMap.get(currentScope);
    }

    private DataBaseManager(AccessPointDescriptor desc) {
        this.url = desc.getUrl();
        this.username = desc.getUsername();
        this.password = desc.getPassword();
        this.connectionPool = new GenericObjectPool();
        this.connectionPool.setMaxActive(10);
        DriverManagerConnectionFactory cf = new DriverManagerConnectionFactory(this.url, this.username, this.password);
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)cf, (ObjectPool)this.connectionPool, null, null, false, true);
        this.dataSource = new PoolingDataSource(pcf.getPool());
    }

    public DataSource getDataSource() throws Exception {
        if (this.dataSource == null) {
            throw new StatisticalManagerException("Data source not initialized ");
        }
        return this.dataSource;
    }

    public String getUrlDB() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriver() {
        return DRIVER;
    }

    public void closeConn(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void rollback(Connection conn) {
        try {
            if (conn != null) {
                conn.rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void closeStatement(Statement stm) {
        try {
            if (stm != null) {
                stm.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTable(String tableId) throws Exception {
        Connection conn = this.getDataSource().getConnection();
        Statement stmt = null;
        try {
            String sql = "DROP TABLE " + tableId;
            stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            this.closeStatement(stmt);
            this.closeConn(conn);
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConn(conn);
            throw throwable;
        }
    }

    static {
        try {
            Class.forName(DRIVER).newInstance();
        }
        catch (Throwable t) {
            logger.error("Unable to initialize db driver org.postgresql.Driver", t);
        }
        dbMap = new ConcurrentHashMap();
    }
}

