/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.ComputationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteStorage {
    private static Logger logger = LoggerFactory.getLogger(ComputationResource.class);
    private static XStream xstream = new XStream();
    private IClient storage = new StorageClient(ServiceContext.class.getPackage().getName(), ServiceContext.SERVICE_NAME, ServiceContext.SERVICE_NAME, AccessType.SHARED).getClient();

    public String putFile(File f, boolean randomName) {
        return this.storage.put(true).LFile(f.getAbsolutePath()).RFile(randomName ? UUID.randomUUID().toString() : f.getName());
    }

    public String putStream(InputStream is, String path) {
        return this.storage.put(true).LFile(is).RFile(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putObject(Object outputs) throws IOException {
        String string;
        File file = File.createTempFile("output", "smf");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            xstream.toXML(outputs, (OutputStream)fos);
            string = this.putFile(file, false);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            FileUtils.deleteQuietly((File)file);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
        FileUtils.deleteQuietly((File)file);
        return string;
    }

    public String getUrlById(String id) {
        return this.storage.getUrl().RFile(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File importByUri(String uri) throws MalformedURLException, FileNotFoundException, IOException {
        File f = File.createTempFile("import", "smf");
        InputStream is = null;
        OutputStream os = null;
        try {
            IOUtils.copy((InputStream)this.getStreamByUrl(uri), (OutputStream)new FileOutputStream(f));
            File file = f;
            return file;
        }
        finally {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
        }
    }

    public InputStream getStreamByUrl(String url) throws MalformedURLException, IOException {
        URL myUrl = new URL(url);
        URLConnection conn = myUrl.openConnection();
        return conn.getInputStream();
    }

    public File importById(String id) throws IOException {
        File toReturn = File.createTempFile("import", "smf");
        this.storage.get().LFile(toReturn.getAbsolutePath()).RFile(id);
        return toReturn;
    }
}

