/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.tika.io.IOUtils;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.types.VOID;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.Configuration;
import org.gcube.data.analysis.statisticalmanager.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.SMOperationType;
import org.gcube.data.analysis.statisticalmanager.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.dataspace.exporter.CSVExporter;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVImporter;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.OccurrenceStreamConverter;
import org.gcube.data.analysis.statisticalmanager.exception.HibernateManagementException;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.data.analysis.statisticalmanager.persistence.HibernateManager;
import org.gcube.data.analysis.statisticalmanager.persistence.RemoteStorage;
import org.gcube.data.analysis.statisticalmanager.persistence.SMPersistenceManager;
import org.gcube.data.analysis.statisticalmanager.stubs.DataSpacePortType;
import org.gcube.data.analysis.statisticalmanager.stubs.SMCreateTableFromCSVRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMCreateTableFromDataStreamRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMCreateTableRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMCreatedTablesRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMFiles;
import org.gcube.data.analysis.statisticalmanager.stubs.SMGetFilesRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImporters;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImportersRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMResourceNotFoundFault;
import org.gcube.data.analysis.statisticalmanager.stubs.SMResources;
import org.gcube.data.analysis.statisticalmanager.stubs.SMTables;
import org.gcube.data.analysis.statisticalmanager.stubs.SMimportDwcaFileRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMimportFileRequest;
import org.gcube.data.analysis.statisticalmanager.util.ServiceUtil;
import org.gcube.data.spd.model.binding.Bindings;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.delegates.PipedStream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMFile;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMImport;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTable;
import org.hibernate.Query;
import org.hibernate.classic.Session;

public class DataSpace
extends GCUBEPortType
implements DataSpacePortType {
    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public String getDBParameters(String string) throws RemoteException, GCUBEFault {
        try {
            DataBaseManager dbMng = DataBaseManager.get();
            String url = String.valueOf(dbMng.getUrlDB()) + "?user=" + dbMng.getUsername() + "&password=" + dbMng.getPassword();
            return url;
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to access DB", (Throwable)e);
            throw new GCUBEFault(new String[]{"Unable to access Database parameters"});
        }
    }

    public SMImporters getImporters(SMImportersRequest request) throws RemoteException, GCUBEFault {
        HibernateManager hMng = HibernateManager.get();
        Session session = hMng.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select importer from SMImport  importer where importer.portalLogin like :name ");
            query.setParameter("name", (Object)(request.getUser() != null ? request.getUser() : "%"));
            List objects = query.list();
            SMImport[] importers = objects.toArray(new SMImport[objects.size()]);
            SMImporters sMImporters = new SMImporters(importers);
            hMng.closeSession((org.hibernate.Session)session);
            return sMImporters;
        }
        catch (Throwable throwable) {
            try {
                hMng.closeSession((org.hibernate.Session)session);
                throw throwable;
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to access Persistence", (Throwable)e);
                throw new GCUBEFault(new String[]{"Unable to access persistence"});
            }
        }
    }

    public long createTableFromDataStream(SMCreateTableFromDataStreamRequest request) throws RemoteException, GCUBEFault {
        try {
            final String callerScope = ScopeProvider.instance.get();
            long importerId = SMPersistenceManager.addImporter((SMCreateTableRequest)request);
            Stream genericRecords = Streams.convert((URI)URI.create(request.getRsLocator())).of(GenericRecord.class).withDefaults();
            Generator<GenericRecord, OccurrencePoint> generator = new Generator<GenericRecord, OccurrencePoint>(){

                public OccurrencePoint yield(GenericRecord element) {
                    try {
                        return (OccurrencePoint)Bindings.fromXml((String)((StringField)element.getField("result")).getPayload());
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
            PipedStream stream = Streams.pipe((Stream)genericRecords).through((Generator)generator);
            Thread th = new Thread((Stream)stream, request, importerId){
                private final /* synthetic */ Stream val$stream;
                private final /* synthetic */ SMCreateTableFromDataStreamRequest val$request;
                private final /* synthetic */ long val$importerId;
                {
                    this.val$stream = stream;
                    this.val$request = sMCreateTableFromDataStreamRequest;
                    this.val$importerId = l;
                }

                @Override
                public void run() {
                    String resourceId = null;
                    try {
                        DataSpace.this.logger.debug((Object)("Init import from stream under scope " + callerScope));
                        ScopeProvider.instance.set(callerScope);
                        OccurrenceStreamConverter converter = new OccurrenceStreamConverter(DataBaseManager.get(), (Stream<OccurrencePoint>)this.val$stream);
                        converter.run();
                        resourceId = converter.getTableName();
                        SMTable table = new SMTable(this.val$request.getTableType());
                        table.setResourceType(SMResourceType.TABULAR.ordinal());
                        table.setResourceId(resourceId);
                        table.setName(this.val$request.getTableName());
                        table.setDescription(this.val$request.getDescription());
                        table.setCreationDate(Calendar.getInstance());
                        table.setPortalLogin(this.val$request.getUser());
                        table.setProvenance(SMOperationType.IMPORTED.ordinal());
                        table.setOperationId(this.val$importerId);
                        SMPersistenceManager.addCreatedResource(this.val$importerId, (SMResource)table);
                    }
                    catch (Exception e) {
                        try {
                            SMPersistenceManager.setOperationStatus(this.val$importerId, "Import failed ", ServiceUtil.formatDetailedErrorMessage(e), SMOperationStatus.FAILED);
                        }
                        catch (Exception e1) {
                            DataSpace.this.logger.fatal((Object)"Unable to accessPersistence ", (Throwable)e1);
                        }
                    }
                }
            };
            th.start();
            return importerId;
        }
        catch (Exception e) {
            this.logger.error((Object)"Unexpected Error ", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
    }

    public long createTableFromCSV(final SMCreateTableFromCSVRequest request) throws RemoteException, GCUBEFault {
        try {
            final long importerId = SMPersistenceManager.addImporter((SMCreateTableRequest)request);
            final String callerScope = ScopeProvider.instance.get();
            this.logger.debug((Object)"retrieve file ");
            this.logger.debug((Object)("Locator :" + request.getRsLocator()));
            final File file = new RemoteStorage().importById(request.getRsLocator());
            this.logger.debug((Object)("File created " + file));
            Thread th = new Thread(){

                @Override
                public void run() {
                    try {
                        DataSpace.this.logger.debug((Object)("Init import under scope " + callerScope));
                        ScopeProvider.instance.set(callerScope);
                        CSVImporter converter = new CSVImporter(file, request.isHasHeader(), request.getTableName(), request.getTableType(), request.getDelimiter(), request.getCommentChar());
                        String resourceId = converter.toTabularData();
                        DataSpace.this.logger.debug((Object)("Import completed with resource id " + resourceId));
                        SMTable table = new SMTable(request.getTableType());
                        table.setResourceType(SMResourceType.TABULAR.ordinal());
                        table.setResourceId(resourceId);
                        table.setName(request.getTableName());
                        table.setDescription(request.getDescription());
                        table.setCreationDate(Calendar.getInstance());
                        table.setPortalLogin(request.getUser());
                        table.setProvenance(SMOperationType.IMPORTED.ordinal());
                        table.setOperationId(importerId);
                        SMPersistenceManager.addCreatedResource((SMResource)table);
                        SMPersistenceManager.addCreatedResource(importerId, (SMResource)table);
                    }
                    catch (HibernateManagementException converter) {
                    }
                    catch (Exception e) {
                        DataSpace.this.logger.error((Object)"Import failed ", (Throwable)e);
                        DataSpace.this.logger.error((Object)("Messagge: " + e.getMessage()), (Throwable)e);
                        try {
                            SMPersistenceManager.setOperationStatus(importerId, "Import failed.", e.getMessage(), SMOperationStatus.FAILED);
                        }
                        catch (Exception e1) {
                            DataSpace.this.logger.fatal((Object)"Unable to accessPersistence ", (Throwable)e1);
                        }
                    }
                }
            };
            th.start();
            return importerId;
        }
        catch (Exception e) {
            this.logger.error((Object)"Unexpected Error ", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
    }

    public SMTables getTables(SMCreatedTablesRequest request) throws RemoteException, GCUBEFault {
        HibernateManager hMng = HibernateManager.get();
        Session session = hMng.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select table from SMTable table where (table.portalLogin like :name or table.portalLogin = null) and table.template like :template");
            query.setParameter("name", (Object)(request.getUser() != null ? request.getUser() : "%"));
            String template = request.getTemplate();
            query.setParameter("template", (Object)(template != null && !template.equals(TableTemplates.GENERIC) ? template : "%"));
            List objects = query.list();
            SMTable[] tables = objects.toArray(new SMTable[objects.size()]);
            SMTables sMTables = new SMTables(tables);
            hMng.closeSession((org.hibernate.Session)session);
            return sMTables;
        }
        catch (Throwable throwable) {
            try {
                hMng.closeSession((org.hibernate.Session)session);
                throw throwable;
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to access persistence");
                throw new GCUBEFault(new String[]{"Unable to access persistence"});
            }
        }
    }

    public SMImport getImporter(String importerId) throws RemoteException, GCUBEFault {
        HibernateManager hMng = HibernateManager.get();
        Session session = hMng.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select importer from SMImport  importer where importer.operationId = :operationId");
            query.setParameter("operationId", (Object)Long.valueOf(importerId));
            List objects = query.list();
            SMImport sMImport = (SMImport)objects.get(0);
            hMng.closeSession((org.hibernate.Session)session);
            return sMImport;
        }
        catch (Throwable throwable) {
            try {
                hMng.closeSession((org.hibernate.Session)session);
                throw throwable;
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to access persistence", (Throwable)e);
                throw new GCUBEFault(new String[]{"Unable to access persistence"});
            }
        }
    }

    public VOID removeImporter(String operationId) throws RemoteException, GCUBEFault {
        try {
            SMPersistenceManager.removeImporter(Long.valueOf(operationId));
            return new VOID();
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to access persistence", (Throwable)e);
            throw new GCUBEFault(new String[]{"Unable to access persistence"});
        }
    }

    public SMResources getResources(SMCreatedTablesRequest request) throws RemoteException, GCUBEFault {
        try {
            List<SMResource> resources = SMPersistenceManager.getResources(request.getUser(), request.getTemplate());
            return new SMResources(resources.toArray(new SMResource[resources.size()]));
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to access persistence", (Throwable)e);
            throw new GCUBEFault(new String[]{"Unable to access persistence"});
        }
    }

    public VOID removeTable(String tableId) throws RemoteException, GCUBEFault {
        try {
            SMPersistenceManager.removeResource(tableId, Boolean.parseBoolean(Configuration.getProperty("FORCE_COMPUTATION_REMOVAL")));
            return new VOID();
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to access persistence", (Throwable)e);
            throw new GCUBEFault(new String[]{"Unable to access persistence"});
        }
    }

    public String exportTable(String tableId) throws RemoteException, SMResourceNotFoundFault, GCUBEFault {
        File file = null;
        try {
            file = File.createTempFile("export", "csv");
            CSVExporter exporter = new CSVExporter(tableId, file);
            exporter.exporterToFile();
            String string = new RemoteStorage().putFile(file, true);
            return string;
        }
        catch (SQLException e) {
            this.logger.error((Object)"Resource not retrieved ", (Throwable)e);
            throw new SMResourceNotFoundFault();
        }
        catch (StatisticalManagerException e) {
            this.logger.debug((Object)"Data base connection internal error ", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        catch (IOException e) {
            this.logger.error((Object)"Temp file to export did not create", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unexpected Error ", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        finally {
            try {
                if (file != null) {
                    FileUtils.forceDelete((File)file);
                }
            }
            catch (Throwable t) {
                this.logger.warn((Object)("Unable to delete file " + file.getAbsolutePath()), t);
            }
        }
    }

    public SMFiles getFiles(SMGetFilesRequest request) throws RemoteException, GCUBEFault {
        HibernateManager hMng = HibernateManager.get();
        Session session = hMng.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select file from SMFile file where (file.portalLogin like :name or file.portalLogin = null)");
            query.setParameter("name", (Object)(request.getUser() != null ? request.getUser() : "%"));
            List objects = query.list();
            SMFile[] files = objects.toArray(new SMFile[objects.size()]);
            SMFiles sMFiles = new SMFiles(files);
            hMng.closeSession((org.hibernate.Session)session);
            return sMFiles;
        }
        catch (Throwable throwable) {
            try {
                hMng.closeSession((org.hibernate.Session)session);
                throw throwable;
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to access persistence", (Throwable)e);
                throw new GCUBEFault(new String[]{"Unable to access persistence"});
            }
        }
    }

    public long importFromFile(final SMimportFileRequest request) throws RemoteException, GCUBEFault {
        try {
            final String callerScope = ScopeProvider.instance.get();
            final long importerId = SMPersistenceManager.addImporter((SMCreateTableRequest)request);
            this.logger.debug((Object)("Received request import file  " + request.getRsLocator() + " under scope " + callerScope));
            Thread th = new Thread(){

                @Override
                public void run() {
                    block7: {
                        InputStream is = null;
                        try {
                            try {
                                ScopeProvider.instance.set(callerScope);
                                DataSpace.this.logger.debug((Object)("Importing file, scope is  " + ScopeProvider.instance.get()));
                                RemoteStorage stg = new RemoteStorage();
                                is = stg.getStreamByUrl(stg.getUrlById(request.getRsLocator()));
                                DataSpace.this.logger.debug((Object)("Importing file, got input stream, final scope " + ScopeProvider.instance.get()));
                                WorkspaceFolder appFolder = ServiceUtil.getWorkspaceSMFolder(ServiceUtil.getWorkspaceHome(request.getUser()));
                                DataSpace.this.logger.debug((Object)("Importing file, Got workspace home, final scope " + ScopeProvider.instance.get()));
                                ExternalFile f = appFolder.createExternalFileItem(request.getFileName(), request.getDescription(), null, is);
                                DataSpace.this.logger.debug((Object)("Importing file, stored file in home, final scope " + ScopeProvider.instance.get()));
                                String url = f.getPublicLink();
                                DataSpace.this.logger.debug((Object)("Importing file, got public link, final scope " + ScopeProvider.instance.get()));
                                SMFile file = new SMFile("mimeType", request.getFileName(), url);
                                file.setPortalLogin(request.getUser());
                                file.setResourceType(SMResourceType.FILE.ordinal());
                                file.setResourceId(UUID.randomUUID().toString());
                                file.setDescription(request.getDescription());
                                file.setName(request.getFileName());
                                file.setProvenance(SMOperationType.IMPORTED.ordinal());
                                file.setCreationDate(Calendar.getInstance());
                                file.setOperationId(importerId);
                                DataSpace.this.logger.debug((Object)("Inserting reference for imported file under scope " + ScopeProvider.instance.get()));
                                SMPersistenceManager.addCreatedResource((SMResource)file);
                                DataSpace.this.logger.debug((Object)("Inserting reference for importer of file under scope " + ScopeProvider.instance.get()));
                                SMPersistenceManager.addCreatedResource(importerId, (SMResource)file);
                                DataSpace.this.logger.debug((Object)("Import file request served, scope " + ScopeProvider.instance.get()));
                            }
                            catch (Exception e) {
                                try {
                                    SMPersistenceManager.setOperationStatus(importerId, "Import failed ", ServiceUtil.formatDetailedErrorMessage(e), SMOperationStatus.FAILED);
                                }
                                catch (Exception e1) {
                                    DataSpace.this.logger.fatal((Object)"Unable to accessPersistence ", (Throwable)e1);
                                }
                                IOUtils.closeQuietly(is);
                                break block7;
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(is);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)is);
                    }
                }
            };
            th.start();
            return importerId;
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unexpected Error ", (Throwable)ex);
            throw new GCUBEUnrecoverableException((Throwable)ex).toFault(new String[0]);
        }
    }

    public long importFromDwcaFile(final SMimportDwcaFileRequest request) throws RemoteException, GCUBEFault {
        try {
            final long importerId = SMPersistenceManager.addImporter((SMCreateTableRequest)request);
            final String callerScope = ScopeProvider.instance.get();
            this.logger.debug((Object)"retrieve file ");
            this.logger.debug((Object)("Locator :" + request.getRsLocator()));
            this.logger.debug((Object)("Locator taxa :" + request.getTaxaLocator()));
            this.logger.debug((Object)("Locator taxa :" + request.getVernacularLocator()));
            Thread th = new Thread(){

                @Override
                public void run() {
                    block7: {
                        InputStream importIs = null;
                        InputStream taxaIs = null;
                        InputStream vernacularIs = null;
                        ScopeProvider.instance.set(callerScope);
                        try {
                            try {
                                RemoteStorage stg = new RemoteStorage();
                                importIs = stg.getStreamByUrl(stg.getUrlById(request.getRsLocator()));
                                taxaIs = stg.getStreamByUrl(stg.getUrlById(request.getTaxaLocator()));
                                vernacularIs = stg.getStreamByUrl(stg.getUrlById(request.getVernacularLocator()));
                                WorkspaceFolder appFolder = ServiceUtil.getWorkspaceSMFolder(ServiceUtil.getWorkspaceHome(request.getUser()));
                                WorkspaceFolder subFolder = appFolder.createFolder(request.getFileName(), "SM import DWCA");
                                subFolder.createExternalFileItem(request.getFileName(), request.getDescription(), null, importIs);
                                subFolder.createExternalFileItem(String.valueOf(request.getFileName()) + "_Taxa", request.getDescription(), null, taxaIs);
                                subFolder.createExternalFileItem(String.valueOf(request.getFileName()) + "_Vernacular", request.getDescription(), null, vernacularIs);
                                String url = subFolder.getPath();
                                SMFile file = new SMFile("dwca/directory", request.getFileName(), url);
                                file.getMimeType();
                                file.setPortalLogin(request.getUser());
                                file.setResourceType(SMResourceType.FILE.ordinal());
                                file.setResourceId(UUID.randomUUID().toString());
                                file.setDescription(request.getDescription());
                                file.setName(request.getFileName());
                                file.setProvenance(SMOperationType.IMPORTED.ordinal());
                                file.setCreationDate(Calendar.getInstance());
                                file.setOperationId(importerId);
                                SMPersistenceManager.addCreatedResource((SMResource)file);
                                SMPersistenceManager.addCreatedResource(importerId, (SMResource)file);
                            }
                            catch (Exception e) {
                                try {
                                    SMPersistenceManager.setOperationStatus(importerId, "Import failed ", ServiceUtil.formatDetailedErrorMessage(e), SMOperationStatus.FAILED);
                                }
                                catch (Exception e1) {
                                    DataSpace.this.logger.fatal((Object)"Unable to accessPersistence ", (Throwable)e1);
                                }
                                IOUtils.closeQuietly((InputStream)importIs);
                                IOUtils.closeQuietly(taxaIs);
                                IOUtils.closeQuietly(vernacularIs);
                                break block7;
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(importIs);
                            IOUtils.closeQuietly(taxaIs);
                            IOUtils.closeQuietly(vernacularIs);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)importIs);
                        IOUtils.closeQuietly((InputStream)taxaIs);
                        IOUtils.closeQuietly((InputStream)vernacularIs);
                    }
                }
            };
            th.start();
            this.logger.debug((Object)("Return  " + importerId));
            return importerId;
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unexpected Error ", (Throwable)ex);
            throw new GCUBEUnrecoverableException((Throwable)ex).toFault(new String[0]);
        }
    }
}

