/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.experimentspace.genericresources;

import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.statisticalmanager.Configuration;
import org.gcube.data.analysis.statisticalmanager.experimentspace.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRGenerator {
    private static Logger logger = LoggerFactory.getLogger(GenericRGenerator.class);
    public static int consecutiveCall = 0;

    protected StringBuilder createGR(SMAlgorithm a, String name, String description, List<StatisticalType> parameters) throws Exception {
        StringBuilder xml = new StringBuilder();
        ArrayList<SMParameter> listParameters = new ArrayList<SMParameter>();
        xml.append("<Resource version=\"0.4.x\">");
        xml.append("<Type>GenericResource</Type>");
        xml.append("<Profile>");
        xml.append("<SecondaryType>");
        xml.append(Configuration.getProperty("GR_SECONDARY_TYPE"));
        xml.append("</SecondaryType>");
        xml.append("<Name>");
        xml.append(name);
        xml.append("</Name>");
        xml.append("<Description>");
        xml.append(description);
        xml.append("</Description>");
        xml.append("<Body>");
        xml.append("<category>");
        xml.append(a.getCategory());
        xml.append("</category>");
        for (StatisticalType param : parameters) {
            SMParameter smParameter = FactoryComputationParameter.createParameter(param);
            if (smParameter == null) continue;
            listParameters.add(smParameter);
        }
        SMParameters smParameters = new SMParameters(listParameters.toArray(new SMParameter[listParameters.size()]));
        xml.append("<inputs>");
        for (SMParameter smParam : smParameters.getList()) {
            xml.append("<input><name>" + smParam.getName() + "</name>" + "<description>" + smParam.getDescription() + "</description>" + "<defaultValue>" + smParam.getDefaultValue() + "</defaultValue>" + "<type>" + smParam.getType().getName() + "</type>" + "</input>");
        }
        xml.append("</inputs>");
        xml.append("</Body>");
        xml.append("</Profile>");
        xml.append("</Resource>");
        return xml;
    }
}

