/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.experimentspace;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.data.access.queueManager.model.RequestItem;
import org.gcube.data.analysis.statisticalmanager.Configuration;
import org.gcube.data.analysis.statisticalmanager.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.experimentspace.AlgorithmCategory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactoryContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactoryResource;
import org.gcube.data.analysis.statisticalmanager.experimentspace.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.persistence.HibernateManager;
import org.gcube.data.analysis.statisticalmanager.persistence.SMPersistenceManager;
import org.gcube.data.analysis.statisticalmanager.persistence.ServiceQueueManager;
import org.gcube.data.analysis.statisticalmanager.persistence.algorithms.AlgorithmCategoryDescriptor;
import org.gcube.data.analysis.statisticalmanager.persistence.algorithms.AlgorithmDescriptor;
import org.gcube.data.analysis.statisticalmanager.persistence.algorithms.AlgorithmManager;
import org.gcube.data.analysis.statisticalmanager.stubs.ComputationFactoryPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithmsRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationConfig;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputations;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationsRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMOutput;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameters;
import org.gcube.data.analysis.statisticalmanager.util.ScopeUtils;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntries;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntry;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMInputEntry;
import org.hibernate.Query;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputationFactory
extends GCUBEPortType
implements ComputationFactoryPortType {
    private static Logger logger = LoggerFactory.getLogger(ComputationFactory.class);
    private static final String keyFRString = "keyFactoryResource";
    private static ComputationFactoryResource resource;

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public static ComputationFactoryResource getFactoryResource() {
        return resource;
    }

    protected void onInitialisation() throws Exception {
        if (resource == null) {
            logger.info("Initialising the factory state...");
            new Thread(){

                @Override
                public void run() {
                    int attempts = 0;
                    boolean created = false;
                    while (attempts++ < 10) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e1) {
                            logger.error("Failed to sleep in between factory creation");
                            ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
                            break;
                        }
                        try {
                            GCUBEScope[] gCUBEScopeArray = ServiceContext.getContext().getStartScopes();
                            int n = gCUBEScopeArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                GCUBEScope scope = gCUBEScopeArray[n2];
                                logger.debug("Creating the singleton factory resource within the scope " + scope);
                                ScopeUtils.setAuthorizationSettings(new ScopeUtils.ScopeBean(scope.toString(), null));
                                resource = (ComputationFactoryResource)ComputationFactoryContext.getContext().getWSHome().create(ComputationFactoryContext.getContext().makeKey(ComputationFactory.keyFRString), new Object[0]);
                                ++n2;
                            }
                            created = true;
                            break;
                        }
                        catch (Exception e) {
                            logger.error("Failed to create the resource", (Throwable)e);
                        }
                    }
                    if (!created) {
                        ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
                    }
                }
            }.start();
        }
    }

    public SMOutput getAlgorithmOutputs(String algorithm) throws RemoteException, GCUBEFault {
        StatisticalType outputs = null;
        try {
            logger.debug("get Output for " + algorithm);
            outputs = AlgorithmManager.getAlgorithmByName(algorithm).getOutput();
            if (outputs != null) {
                SMOutput output = new SMOutput();
                output.setDescription(outputs.getDescription());
                output.setName(outputs.getName());
                if (outputs instanceof OutputTable) {
                    logger.debug("table");
                    output.setSize(1);
                    output.setType(output.getName());
                }
                if (outputs instanceof PrimitiveType) {
                    PrimitiveType primitiveObject = (PrimitiveType)outputs;
                    if (primitiveObject.getType() == PrimitiveTypes.MAP) {
                        Map map = (Map)primitiveObject.getContent();
                        logger.debug("map");
                        output.setSize(map.entrySet().size());
                        output.setType(PrimitiveTypes.MAP.name());
                    } else if (primitiveObject.getType() == PrimitiveTypes.IMAGES) {
                        output.setType(PrimitiveTypes.IMAGES.name());
                        output.setSize(1);
                        logger.debug("image");
                    } else if (primitiveObject.getType() == PrimitiveTypes.FILE) {
                        output.setSize(1);
                        output.setType(PrimitiveTypes.FILE.name());
                        logger.debug("file");
                    } else {
                        if (primitiveObject.getType() == PrimitiveTypes.STRING) {
                            output.setSize(1);
                        }
                        logger.debug("string");
                        output.setType(PrimitiveTypes.STRING.name());
                    }
                }
                return output;
            }
        }
        catch (Exception e) {
            logger.debug("Parameters unknown", (Throwable)e);
            throw new StatisticalManagerException("Parameters unknown for this computation", e).asGCUBEFault();
        }
        return null;
    }

    public SMParameters getAlgorithmParameters(String algorithm) throws RemoteException, GCUBEFault {
        Collection<StatisticalType> parameters = null;
        try {
            parameters = AlgorithmManager.getAlgorithmByName(algorithm).getParameters().values();
        }
        catch (Exception e) {
            throw new StatisticalManagerException("Unknown parameters", e).asGCUBEFault();
        }
        logger.debug("------------- parameters retrieved");
        ArrayList<SMParameter> listParameters = new ArrayList<SMParameter>();
        for (StatisticalType param : parameters) {
            SMParameter smParameter = FactoryComputationParameter.createParameter(param);
            if (smParameter == null) continue;
            listParameters.add(smParameter);
        }
        return new SMParameters(listParameters.toArray(new SMParameter[listParameters.size()]));
    }

    public SMListGroupedAlgorithms getAlgorithmsUser(SMAlgorithmsRequest request) throws RemoteException, GCUBEFault {
        logger.debug("Called get user perspective");
        try {
            Map<AlgorithmCategory, AlgorithmCategoryDescriptor> map = AlgorithmManager.getAvailableAlgorithms(request.getParameters());
            return AlgorithmManager.groupByUserPerspective(map);
        }
        catch (Exception e) {
            logger.error("Get features error ", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
    }

    public SMListGroupedAlgorithms getAlgorithms(SMAlgorithmsRequest request) throws RemoteException, GCUBEFault {
        logger.debug("Called get all algorithm");
        try {
            Map<AlgorithmCategory, AlgorithmCategoryDescriptor> map = AlgorithmManager.getAvailableAlgorithms(request.getParameters());
            return AlgorithmManager.asGroup(map);
        }
        catch (Exception e) {
            logger.error("Get features error ", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
    }

    public SMComputations getComputations(SMComputationsRequest request) throws RemoteException, GCUBEFault {
        logger.trace("List computations request by user " + request.getUser());
        try {
            List<SMComputation> toReturn = null;
            if (request.getParameters() == null) {
                toReturn = SMPersistenceManager.getComputations(request.getUser(), null, null);
            } else {
                for (Map.Entry<AlgorithmCategory, AlgorithmCategoryDescriptor> entry : AlgorithmManager.getAvailableAlgorithms(request.getParameters()).entrySet()) {
                    for (AlgorithmDescriptor algo : entry.getValue().getAlgorithms().values()) {
                        toReturn.addAll(SMPersistenceManager.getComputations(request.getUser(), algo.getName(), algo.getCategory().name()));
                    }
                }
            }
            return new SMComputations(toReturn.toArray(new SMComputation[toReturn.size()]));
        }
        catch (Exception e) {
            logger.error("Get Computations error ", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
    }

    public String executeComputation(SMComputationRequest requestComputation) throws RemoteException, GCUBEFault {
        try {
            return this.executeComputation(requestComputation, null);
        }
        catch (Exception e) {
            logger.error("Unable to execute", (Throwable)e);
            throw new StatisticalManagerException("Unable to execute", e).asGCUBEFault();
        }
    }

    private String executeComputation(SMComputationRequest requestComputation, String computationId) throws Exception {
        logger.debug("Execute computation : " + computationId + " under scope " + ScopeUtils.getCurrentScope());
        String category = AlgorithmManager.getAlgorithmByName(requestComputation.getConfig().getAlgorithm()).getCategory().name();
        if (computationId == null) {
            long id = SMPersistenceManager.addComputation(requestComputation, category);
            computationId = String.valueOf(id);
        } else {
            SMPersistenceManager.setOperationStatus(Long.parseLong(computationId), "", "", SMOperationStatus.PENDING);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(Configuration.getProperty(Configuration.JMS_MESSAGE_REQUEST), requestComputation);
        parameters.put(Configuration.getProperty(Configuration.JMS_MESSAGE_COMPUTATION_ID), computationId);
        parameters.put(Configuration.getProperty(Configuration.JMS_MESSAGE_SCOPE), ScopeUtils.getCurrentScope());
        parameters.put(Configuration.getProperty(Configuration.JMS_MESSAGE_TOKEN), ScopeUtils.getToken());
        ServiceQueueManager.sendItem(new RequestItem("CallScript", null, parameters));
        return String.valueOf(computationId);
    }

    public SMComputation getComputation(String computationId) throws RemoteException, GCUBEFault {
        HibernateManager mng = null;
        Session session = null;
        try {
            mng = HibernateManager.get();
            session = mng.getSessionFactory().openSession();
            Query query = session.createQuery("select computation from SMComputation computation where computation.operationId = :name");
            query.setParameter("name", (Object)Long.valueOf(computationId));
            List objects = query.list();
            SMComputation computation = (SMComputation)objects.get(0);
            Query queryParameters = session.createQuery("select parameter from SMEntry parameter where parameter.computationId = :operationId");
            queryParameters.setParameter("operationId", (Object)computation.getOperationId());
            List parameters = queryParameters.list();
            computation.setParameters(parameters.toArray(new SMEntry[parameters.size()]));
            SMComputation sMComputation = (SMComputation)objects.get(0);
            return sMComputation;
        }
        catch (StatisticalManagerException e) {
            throw e.asGCUBEFault();
        }
        catch (Exception e) {
            throw new StatisticalManagerException("Unexpected exception", e).asGCUBEFault();
        }
        finally {
            if (session != null) {
                mng.closeSession((org.hibernate.Session)session);
            }
        }
    }

    public VOID removeComputation(String computationId) throws RemoteException, GCUBEFault {
        logger.debug("Remove computation" + computationId + " from factory");
        try {
            SMPersistenceManager.removeComputation(Long.parseLong(computationId), Boolean.parseBoolean(Configuration.getProperty("FORCE_COMPUTATION_REMOVAL")));
            return new VOID();
        }
        catch (StatisticalManagerException e) {
            throw e.asGCUBEFault();
        }
        catch (Exception e) {
            throw new StatisticalManagerException("Unexpected Exception", e).asGCUBEFault();
        }
    }

    public String resubmitComputation(String computationId) throws RemoteException, GCUBEFault {
        try {
            SMComputation computation = (SMComputation)SMPersistenceManager.getOperation(Long.parseLong(computationId));
            ArrayList parameters = new ArrayList();
            HibernateManager mng = HibernateManager.get();
            Session session = mng.getSessionFactory().openSession();
            try {
                Query queryParameters = session.createQuery("select parameter from SMEntry parameter where parameter.computationId = :computationId");
                queryParameters.setParameter("computationId", (Object)computation.getOperationId());
                parameters.addAll(queryParameters.list());
            }
            finally {
                mng.closeSession((org.hibernate.Session)session);
            }
            ArrayList<SMInputEntry> entries = new ArrayList<SMInputEntry>();
            for (SMEntry parameter : parameters) {
                entries.add(new SMInputEntry(parameter.getKey(), parameter.getValue()));
            }
            SMEntries inputEntries = new SMEntries(entries.toArray(new SMInputEntry[entries.size()]));
            SMComputationConfig computationConfig = new SMComputationConfig(computation.getAlgorithm(), inputEntries);
            SMComputationRequest request = new SMComputationRequest(computationConfig, null, null, computation.getPortalLogin());
            logger.debug("Re execute " + computationId + " under scope " + ScopeUtils.getCurrentScope());
            this.executeComputation(request, computationId);
            return computationId;
        }
        catch (Exception e) {
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
    }
}

