/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.util;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeUtils {
    private static final Logger log = LoggerFactory.getLogger(ScopeUtils.class);

    public static ScopeBean getCurrentScopeBean() {
        return new ScopeBean(ScopeProvider.instance.get(), SecurityTokenProvider.instance.get());
    }

    public static String getCurrentScope() {
        String scope = ScopeProvider.instance.get();
        if (scope != null) {
            log.debug("Found scope provider {}, skipping token", (Object)scope);
            return scope;
        }
        try {
            log.debug("Scope provider not set, reverting to token");
            String token = ScopeUtils.getToken();
            log.debug("Token is : " + token);
            if (token == null) {
                throw new Exception("Security Token is null");
            }
            AuthorizationEntry entry = Constants.authorizationService().get(token);
            return entry.getContext();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to evaluate scope ", e);
        }
    }

    public static String getToken() {
        return SecurityTokenProvider.instance.get();
    }

    public static String getCurrentScopeName() {
        String current = ScopeUtils.getCurrentScope();
        return current.substring(current.lastIndexOf(47) + 1);
    }

    public static Set<String> getParentScopes() {
        String currentScope = ScopeUtils.getCurrentScope();
        String[] splitted = currentScope.substring(1).split("/");
        HashSet<String> toReturn = new HashSet<String>();
        int i = 0;
        while (i < splitted.length - 1) {
            toReturn.add(splitted[i]);
            ++i;
        }
        return toReturn;
    }

    public static void setAuthorizationSettings(ScopeBean bean) {
        log.debug("Setting {}", (Object)bean);
        ScopeProvider.instance.set(bean.scopeProviderValue);
        try {
            SecurityTokenProvider.instance.set(bean.tokenValue);
        }
        catch (Throwable e) {
            log.warn("Unable to set token, bean is :" + bean, e);
            SecurityTokenProvider.instance.reset();
        }
    }

    public static void cleanAuthorizationSettings() {
        ScopeProvider.instance.reset();
        SecurityTokenProvider.instance.reset();
    }

    public static class ScopeBean {
        String scopeProviderValue;
        String tokenValue;

        public String getScopeProviderValue() {
            return this.scopeProviderValue;
        }

        public String getTokenValue() {
            return this.tokenValue;
        }

        public void setScopeProviderValue(String scopeProviderValue) {
            this.scopeProviderValue = scopeProviderValue;
        }

        public void setTokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
        }

        @ConstructorProperties(value={"scopeProviderValue", "tokenValue"})
        public ScopeBean(String scopeProviderValue, String tokenValue) {
            this.scopeProviderValue = scopeProviderValue;
            this.tokenValue = tokenValue;
        }

        public String toString() {
            return "ScopeUtils.ScopeBean(scopeProviderValue=" + this.getScopeProviderValue() + ", tokenValue=" + this.getTokenValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScopeBean)) {
                return false;
            }
            ScopeBean other = (ScopeBean)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$scopeProviderValue = this.getScopeProviderValue();
            String other$scopeProviderValue = other.getScopeProviderValue();
            if (this$scopeProviderValue == null ? other$scopeProviderValue != null : !this$scopeProviderValue.equals(other$scopeProviderValue)) {
                return false;
            }
            String this$tokenValue = this.getTokenValue();
            String other$tokenValue = other.getTokenValue();
            return !(this$tokenValue == null ? other$tokenValue != null : !this$tokenValue.equals(other$tokenValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScopeBean;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $scopeProviderValue = this.getScopeProviderValue();
            result = result * 59 + ($scopeProviderValue == null ? 43 : $scopeProviderValue.hashCode());
            String $tokenValue = this.getTokenValue();
            result = result * 59 + ($tokenValue == null ? 43 : $tokenValue.hashCode());
            return result;
        }
    }
}

