/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.data.analysis.statisticalmanager.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.SMOperationType;
import org.gcube.data.analysis.statisticalmanager.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.exception.HLManagementException;
import org.gcube.data.analysis.statisticalmanager.exception.HibernateManagementException;
import org.gcube.data.analysis.statisticalmanager.exception.ISException;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.data.analysis.statisticalmanager.persistence.HibernateManager;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMCreateTableRequest;
import org.gcube.data.analysis.statisticalmanager.util.ObjectFormatter;
import org.gcube.data.analysis.statisticalmanager.util.ServiceUtil;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMAbstractResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntries;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntry;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMError;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMFile;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMImport;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMInputEntry;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMObject;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMOperation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMSystemImport;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPersistenceManager {
    private static Logger logger = LoggerFactory.getLogger(SMPersistenceManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long addImporter(SMCreateTableRequest request) throws ISException, HibernateManagementException {
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMImport smimport = new SMImport();
            smimport.setFileName(request.getTableName());
            smimport.setOperationType(SMOperationType.IMPORTED.ordinal());
            smimport.setPortalLogin(request.getUser());
            smimport.setSubmissionDate(Calendar.getInstance());
            smimport.setDescription(request.getDescription());
            smimport.setOperationStatus(SMOperationStatus.RUNNING.ordinal());
            session.save((Object)smimport);
            t.commit();
            long l = smimport.getOperationId();
            return l;
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCreatedResource(SMResource resource) throws ISException, HibernateManagementException {
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            if (session.get(SMResource.class, (Serializable)((Object)resource.getResourceId())) == null) {
                session.save((Object)resource);
            }
            t.commit();
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long addSystemImporter(String description, SMResource resource) throws ISException, HibernateManagementException {
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMSystemImport smimport = new SMSystemImport();
            smimport.setOperationType(SMOperationType.SYSTEM.ordinal());
            smimport.setSubmissionDate(Calendar.getInstance());
            smimport.setDescription(description);
            session.save((Object)resource);
            SMAbstractResource ar = new SMAbstractResource();
            ar.setResource(resource);
            ar.setAbstractResourceId(resource.getResourceId());
            session.save((Object)ar);
            smimport.setAbstractResource(ar);
            smimport.setOperationStatus(SMOperationStatus.COMPLETED.ordinal());
            smimport.setCompletedDate(Calendar.getInstance());
            session.saveOrUpdate((Object)smimport);
            t.commit();
            long l = smimport.getOperationId();
            return l;
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SMResource> getResources(String user, String template) throws ISException, HibernateManagementException {
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select resource from SMResource resource where (resource.portalLogin like :name or resource.portalLogin = null) and resource.resourceType <> 2 and resource.resourceType <> 3 ");
            query.setParameter("name", (Object)(user != null ? user : "%"));
            List list = query.list();
            return list;
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMOperation getOperation(long operationId) throws ISException, HibernateManagementException {
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        try {
            SMOperation sMOperation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(operationId));
            return sMOperation;
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SMComputation> getComputations(String user, String algorithm, String category) throws ISException, HibernateManagementException {
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        ArrayList<SMComputation> toReturn = new ArrayList<SMComputation>();
        try {
            Query query = session.createQuery("select computation from SMComputation  computation where computation.portalLogin like :name and computation.algorithm like :algorithm and computation.category like :category");
            query.setParameter("name", (Object)(user != null ? user : "%"));
            query.setParameter("algorithm", (Object)(algorithm != null ? algorithm : "%"));
            query.setParameter("category", (Object)(category != null ? category : "%"));
            List objects = query.list();
            for (Object object : objects) {
                SMComputation computation = (SMComputation)object;
                Query queryParameters = session.createQuery("select parameter from SMEntry parameter where parameter.computationId = :computationId");
                queryParameters.setParameter("computationId", (Object)computation.getOperationId());
                List parameters = queryParameters.list();
                if (!parameters.isEmpty()) {
                    computation.setParameters(parameters.toArray(new SMEntry[parameters.size()]));
                }
                toReturn.add(computation);
            }
            ArrayList<SMComputation> arrayList = toReturn;
            return arrayList;
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long addComputation(SMComputationRequest request, String category) throws ISException, HibernateManagementException {
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMComputation smcomputation = new SMComputation();
            smcomputation.setOperationType(SMOperationType.COMPUTED.ordinal());
            smcomputation.setPortalLogin(request.getUser());
            smcomputation.setSubmissionDate(Calendar.getInstance());
            smcomputation.setTitle(request.getTitle());
            smcomputation.setDescription(request.getDescription());
            String algorithm = request.getConfig().getAlgorithm();
            smcomputation.setAlgorithm(algorithm);
            smcomputation.setCategory(category);
            smcomputation.setOperationStatus(SMOperationStatus.PENDING.ordinal());
            session.save((Object)smcomputation);
            SMEntries parameters = request.getConfig().getParameters();
            if (parameters.getList() != null) {
                for (SMInputEntry parameter : parameters.getList()) {
                    SMEntry entry = new SMEntry();
                    entry.setKey(parameter.getKey());
                    entry.setValue(parameter.getValue());
                    entry.setComputationId(smcomputation.getOperationId());
                    session.save((Object)entry);
                }
            }
            t.commit();
            long l = smcomputation.getOperationId();
            return l;
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCreatedResource(long operationId, SMResource resource) throws ISException, HibernateManagementException {
        logger.debug("------------------------------------------------------");
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMOperation operation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(operationId));
            logger.debug("Resource type " + SMResourceType.values()[resource.getResourceType()]);
            switch (SMResourceType.values()[resource.getResourceType()]) {
                case OBJECT: {
                    SMObject object = (SMObject)resource;
                    session.save((Object)object);
                    logger.debug("Resource saved !!!!");
                    logger.debug("-----------------------------------------------------------");
                }
            }
            SMAbstractResource ar = new SMAbstractResource();
            ar.setResource(resource);
            ar.setAbstractResourceId(resource.getResourceId());
            session.save((Object)ar);
            operation.setAbstractResource(ar);
            operation.setOperationStatus(SMOperationStatus.COMPLETED.ordinal());
            operation.setCompletedDate(Calendar.getInstance());
            session.saveOrUpdate((Object)operation);
            t.commit();
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCreatedDWCAResource(long operationId, SMResource resource) throws ISException, HibernateManagementException {
        logger.debug("------------------------------------------------------");
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMOperation operation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(operationId));
            logger.debug("Resource type " + SMResourceType.values()[resource.getResourceType()]);
            SMAbstractResource ar = new SMAbstractResource();
            ar.setResource(resource);
            ar.setAbstractResourceId(resource.getResourceId());
            session.save((Object)ar);
            operation.setAbstractResource(ar);
            operation.setOperationStatus(SMOperationStatus.COMPLETED.ordinal());
            operation.setCompletedDate(Calendar.getInstance());
            session.saveOrUpdate((Object)operation);
            t.commit();
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOperationStatus(long operationId, String errorMessage, String errorDesc, SMOperationStatus status) throws ISException, HibernateManagementException {
        logger.debug(String.format("Set operation (ID %s) to status : %s", operationId, status.name()));
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMOperation smoperation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(operationId));
            smoperation.setOperationStatus(status.ordinal());
            if (status == SMOperationStatus.FAILED) {
                logger.debug("Error message is " + errorMessage);
                logger.debug("Error details : " + errorDesc);
                smoperation.setCompletedDate(Calendar.getInstance());
                SMError error = new SMError(errorMessage);
                error.setDescription(errorDesc);
                error.setResourceId(UUID.randomUUID().toString());
                error.setResourceType(SMResourceType.ERROR.ordinal());
                session.save((Object)error);
                SMAbstractResource ar = new SMAbstractResource();
                ar.setResource((SMResource)error);
                ar.setAbstractResourceId(error.getResourceId());
                session.save((Object)ar);
                smoperation.setAbstractResource(ar);
            }
            if (status == SMOperationStatus.PENDING) {
                smoperation.setSubmissionDate(Calendar.getInstance());
            }
            session.saveOrUpdate((Object)smoperation);
            t.commit();
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setComputationalInfrastructure(long operationId, INFRASTRUCTURE infra) throws ISException, HibernateManagementException {
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMComputation smcomputation = (SMComputation)session.get(SMComputation.class, (Serializable)Long.valueOf(operationId));
            smcomputation.setInfrastructure(infra.toString());
            session.save((Object)smcomputation);
            t.commit();
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }

    private static void removeResourcesByOperationId(org.hibernate.Session session, long operationId, boolean force) throws HLManagementException {
        Query query = session.createQuery("select resource from SMResource  resource where resource.operationId = :operationId ");
        query.setParameter("operationId", (Object)operationId);
        List resources = query.list();
        if (resources != null) {
            for (SMResource resource : resources) {
                String user = resource.getPortalLogin();
                SMResourceType type = SMResourceType.values()[resource.getResourceType()];
                logger.debug("Removing " + ObjectFormatter.log(resource, false));
                try {
                    if (type.equals((Object)SMResourceType.TABULAR)) {
                        DataBaseManager.get().removeTable(resource.getResourceId());
                    } else {
                        Home home = ServiceUtil.getWorkspaceHome(user);
                        Workspace ws = home.getWorkspace();
                        WorkspaceFolder appFolder = ServiceUtil.getWorkspaceSMFolder(home);
                        String path = appFolder.getPath() + "/";
                        path = type.equals((Object)SMResourceType.FILE) ? path + ((SMFile)resource).getRemoteName() : path + resource.getName();
                        logger.debug("Removing from WS, path is " + path);
                        ws.getItemByPath(path).remove();
                    }
                }
                catch (HLManagementException e) {
                    throw e;
                }
                catch (Exception e) {
                    String errorMessage = "Unable to delete " + ObjectFormatter.log(resource, true);
                    logger.error(errorMessage, (Throwable)e);
                    if (!force) {
                        throw new HLManagementException(errorMessage, e);
                    }
                    logger.debug("Force delete is true, continue deletion..");
                }
                session.delete((Object)resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeComputation(long operationId, boolean force) throws ISException, HibernateManagementException, HLManagementException {
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMComputation smoperation = (SMComputation)session.get(SMComputation.class, (Serializable)Long.valueOf(operationId));
            SMPersistenceManager.removeResourcesByOperationId((org.hibernate.Session)session, operationId, force);
            if (smoperation != null) {
                session.delete((Object)smoperation);
            }
            t.commit();
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeResource(String resourceId, boolean forceComputationRemoval) throws ISException, HibernateManagementException, HLManagementException {
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMResource resource = (SMResource)session.get(SMResource.class, (Serializable)((Object)resourceId));
            if (resource != null) {
                SMOperation operation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(resource.getOperationId()));
                if (operation != null) {
                    session.delete((Object)operation);
                }
                SMPersistenceManager.removeResourcesByOperationId((org.hibernate.Session)session, resource.getOperationId(), forceComputationRemoval);
            }
            t.commit();
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeImporter(long importerId) throws ISException, HibernateManagementException {
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMOperation operation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(importerId));
            if (operation != null) {
                session.delete((Object)operation);
            }
            t.commit();
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMFile getFile(String fileId) throws ISException, HibernateManagementException {
        HibernateManager hm = HibernateManager.get();
        Session session = hm.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select file from SMFile  file where resourceId = :fileId");
            query.setParameter("fileId", (Object)fileId);
            List objects = query.list();
            if (!objects.isEmpty()) {
                SMFile sMFile = (SMFile)objects.get(0);
                return sMFile;
            }
            SMFile sMFile = null;
            return sMFile;
        }
        finally {
            hm.closeSession((org.hibernate.Session)session);
        }
    }
}

