/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers.codelist;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.DefaultTableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.IdColumn;
import org.gcube.data.analysis.tabulardata.model.idioms.ColumnIsOfType;
import org.gcube.data.analysis.tabulardata.model.table.Codelist;
import org.gcube.data.analysis.tabulardata.model.table.Table;

public class CodelistCreator
extends DefaultTableCreator {
    private List<Column> newColumns = Lists.newArrayList();
    private Table clonedCodelist = null;
    private List<Column> columnsToRemove = Lists.newArrayList();
    private boolean withData = false;

    public CodelistCreator(DatabaseWrangler dw, CubeMetadataWrangler cmw, TableManager tm) {
        super(dw, cmw, tm);
    }

    @Override
    protected Collection<Column> getAllColumns() {
        ArrayList columns = Lists.newArrayList();
        if (this.clonedCodelist != null) {
            ArrayList clonedColumns = Lists.newArrayList((Iterable)this.clonedCodelist.getColumns());
            clonedColumns.removeAll(this.columnsToRemove);
            columns.addAll(clonedColumns);
        }
        columns.addAll(this.newColumns);
        while (columns.remove(new IdColumn())) {
        }
        return columns;
    }

    @Override
    protected Collection<Column> getNewColumns() {
        ArrayList columns = Lists.newArrayList();
        columns.addAll(this.newColumns);
        return columns;
    }

    @Override
    protected void checkConsistency() throws TableCreationException {
        this.checkDuplicateLabels(this.getAllColumns());
        Collection codeColumns = Collections2.filter(this.getAllColumns(), (Predicate)new ColumnIsOfType(ColumnType.CODE));
        if (codeColumns.isEmpty()) {
            throw new TableCreationException("No column of type " + ColumnType.CODE + " was provided.");
        }
        if (codeColumns.size() > 1) {
            throw new TableCreationException("Too many column of type " + ColumnType.CODE + " were provided.");
        }
        Collection attributeColumns = Collections2.filter(this.getAllColumns(), (Predicate)new ColumnIsOfType(ColumnType.ATTRIBUTE));
        if (attributeColumns.isEmpty()) {
            throw new TableCreationException("No column of type " + ColumnType.ATTRIBUTE + " was provided.");
        }
    }

    @Override
    protected boolean isAllowedColumn(Column column) {
        switch (column.getColumnType()) {
            case CODE: 
            case ATTRIBUTE: 
            case SYSTEM: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void addNewColumn(Column column) {
        this.newColumns.add(column);
    }

    @Override
    protected boolean isAllowedCloneableTable(Table table) {
        switch (table.getTableType()) {
            case CODELIST: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Table getTableToClone() {
        return this.clonedCodelist;
    }

    @Override
    protected void setTableToClone(Table table) {
        this.clonedCodelist = table;
    }

    @Override
    protected boolean isCloneWithData() {
        return this.withData;
    }

    @Override
    protected void setCloneWithData(boolean cloneWithData) {
        this.withData = cloneWithData;
    }

    @Override
    protected Collection<Column> getColumnsToRemove() {
        return this.columnsToRemove;
    }

    @Override
    protected void setColumnsToRemove(Collection<Column> columns) {
        this.columnsToRemove = Lists.newArrayList(columns);
    }

    @Override
    protected Table createBaseTable(String tableName, Collection<Column> columns) {
        return new Codelist(tableName, columns);
    }

    @Override
    protected void addIndexes(String tableName, Collection<Column> columns) {
        for (Column column : columns) {
            switch (column.getColumnType()) {
                case SYSTEM: {
                    return;
                }
            }
            this.dbWrangler.createIndex(tableName, column.getName());
        }
    }
}

