/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.time;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.data.SQLDatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.metadata.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.time.TimeCodelistCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.AnnotationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.DimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.IdColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TimePeriodTypeMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.relationship.ImmutableColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.HierarchicalCodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.TimeCodelistTableType;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;

@Singleton
public class TimeCodelistCreatorImpl
implements TimeCodelistCreator {
    @Inject
    SQLDatabaseWrangler dbWrangler;
    @Inject
    CubeMetadataWrangler cmWrangler;

    @Override
    public Table getTable(PeriodType periodType) {
        try {
            return this.cmWrangler.getTableByName(periodType.getName());
        }
        catch (NoSuchTableException e) {
            throw new RuntimeException("time codelists not initialized");
        }
    }

    @PostConstruct
    private void initilizeTimeCodelistTables() {
        for (PeriodType period : PeriodType.values()) {
            try {
                if (this.cmWrangler.getTableByName(period.getName()) != null) {
                    continue;
                }
            }
            catch (NoSuchTableException e) {
                // empty catch block
            }
            Table codelist = this.createTableMeta(period);
            String tableName = this.createTableOnDb(codelist.getColumns(), period.getName());
            codelist.setName(tableName);
            this.cmWrangler.save(codelist, false);
            List columns = codelist.getColumnsExceptTypes(new Class[]{IdColumnType.class});
            StringBuilder colSnippet = new StringBuilder();
            for (Column col : columns) {
                colSnippet.append(col.getName()).append(",");
            }
            colSnippet.deleteCharAt(colSnippet.lastIndexOf(","));
            this.dbWrangler.executeQuery(String.format("insert into %s (%s) %s", period.getName(), colSnippet.toString(), period.getSeriesSelectQuery()));
        }
        for (Map.Entry hPer : PeriodType.getHierarchicalRelation().entrySet()) {
            for (PeriodType targetPeriod : (List)hPer.getValue()) {
                String hclName = ((PeriodType)hPer.getKey()).getName() + "_" + targetPeriod.getName();
                try {
                    if (this.cmWrangler.getTableByName(hclName) != null) {
                        continue;
                    }
                }
                catch (NoSuchTableException e) {
                    // empty catch block
                }
                Table hTable = this.createHierarchical((PeriodType)hPer.getKey(), targetPeriod);
                hTable.setName(this.createTableOnDb(hTable.getColumns(), hclName));
                this.cmWrangler.save(hTable, false);
                this.dbWrangler.executeQuery(String.format("insert into %1$s (%2$s_id, %3$s_id) SELECT k.id, v.id from  %2$s as k , %3$s v where normalize_%3$s(to_iso_%2$s(k.%2$s_code)) = v.%3$s_code;", hTable.getName(), ((PeriodType)hPer.getKey()).getName().toLowerCase(), targetPeriod.getName().toLowerCase()));
            }
        }
    }

    private Table createHierarchical(PeriodType key, PeriodType value) {
        ArrayList columns = Lists.newArrayList((Object[])new Column[]{IdColumnFactory.create(), this.createDimensionColumn(key), this.createDimensionColumn(value)});
        Table hCodelist = new Table((TableType)new HierarchicalCodelistTableType());
        hCodelist.setColumns((List)columns);
        return hCodelist;
    }

    private Column createDimensionColumn(PeriodType value) {
        Column dimColumn = new DimensionColumnFactory().createDefault();
        dimColumn.setName(value.getName() + "_id");
        dimColumn.setDataType((DataType)new IntegerType());
        dimColumn.setMetadata((ColumnMetadata)new NamesMetadata(Arrays.asList(new ImmutableLocalizedText(value.getName() + "_id"))));
        dimColumn.setRelationship((ColumnRelationship)new ImmutableColumnRelationship(this.getTable(value)));
        return dimColumn;
    }

    private Table createTableMeta(PeriodType periodType) {
        ArrayList columns = Lists.newArrayList((Object[])new Column[]{IdColumnFactory.create(), this.createCodeColumn(periodType), this.createHumanReadableValueColumn(periodType)});
        Table dayCodelist = new Table((TableType)new TimeCodelistTableType());
        dayCodelist.setMetadata((TableMetadata)new TimePeriodTypeMetadata(periodType));
        dayCodelist.setColumns((List)columns);
        return dayCodelist;
    }

    private String createTableOnDb(List<Column> columns, String tableName) {
        this.dbWrangler.createTable(tableName);
        for (Column column : columns) {
            if (column.getColumnType() instanceof IdColumnType) continue;
            this.dbWrangler.addColumn(tableName, column.getName(), column.getDataType());
            this.dbWrangler.setNullable(tableName, column.getName(), false);
            this.dbWrangler.createIndex(tableName, column.getName());
        }
        return tableName;
    }

    private Column createCodeColumn(PeriodType periodType) {
        Column codeColumn = new CodeColumnFactory().createDefault();
        codeColumn.setName(periodType.getName() + "_code");
        codeColumn.setDataType((DataType)new TextType(10));
        codeColumn.setMetadata((ColumnMetadata)new NamesMetadata(Arrays.asList(new ImmutableLocalizedText(periodType.getName() + " code"))));
        return codeColumn;
    }

    private Column createHumanReadableValueColumn(PeriodType periodType) {
        Column dayColumn = new AnnotationColumnFactory().create((DataType)new TextType());
        dayColumn.setName(periodType.getName());
        dayColumn.setMetadata((ColumnMetadata)new NamesMetadata(Arrays.asList(new ImmutableLocalizedText(periodType.getName()))));
        return dayColumn;
    }
}

