package org.gcube.data.analysis.tabulardata.operation.parameters;

import java.util.Map;

import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;

public class ParameterDescriptor {

	private TableId tableId;
	
	private ColumnLocalId columnId;
	
	private Map<String, Object> parameters;
	
	
	public ParameterDescriptor(TableId tableId, ColumnLocalId columnId,
			Map<String, Object> parameters) {
		super();
		this.tableId = tableId;
		this.columnId = columnId;
		this.parameters = parameters;
	}

	public ParameterDescriptor(TableId tableId,
			Map<String, Object> parameters) {
		super();
		this.tableId = tableId;
		this.parameters = parameters;
	}
	
	/**
	 * @return the tableId
	 */
	public TableId getTableId() {
		return tableId;
	}

	/**
	 * @return the columnId
	 */
	public ColumnLocalId getColumnId() {
		return columnId;
	}

	/**
	 * @return the parameters
	 */
	public Map<String, Object> getParameters() {
		return parameters;
	}
	
}
