package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import java.util.Locale;

import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

public class LocaleParameter extends LeafParameter<Locale> {
	
	@SuppressWarnings("unused")
	private LocaleParameter() {}
	
	public LocaleParameter(String identifier, String name, String description, Cardinality cardinality) {
		super(identifier, name, description, cardinality);
	}

	public Locale[] getAvailableLocales(){
		return Locale.getAvailableLocales();
	}

	@Override
	public Class<Locale> getParameterType() {
		return Locale.class;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("LocaleParameter []");
		return builder.toString();
	}

}
