package org.gcube.data.analysis.tabulardata.operation.invocation;

import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;

public class TableScopedInvocationCreator extends InvocationCreator {
	
	private TableId targetTableId;
	
	public TableScopedInvocationCreator(OperationDescriptor descriptor) {
		super(descriptor);
	}

	@Override
	public OperationInvocation create() {
		if (targetTableId==null) throw new RuntimeException("A target table is required for this descriptor");
		return new ImmutableOperationInvocation(targetTableId, null, descriptor, parameters);
	}

	@Override
	public InvocationCreator setTargetTable(TableId tableId) {
		this.targetTableId = tableId;
		return this;
	}


}
