/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.invocation;

import java.util.Map;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationScope;
import org.gcube.data.analysis.tabulardata.operation.invocation.ColumnScopedInvocationCreator;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.invocation.TableScopedInvocationCreator;
import org.gcube.data.analysis.tabulardata.operation.invocation.VoidScopedInvocationCreator;

public abstract class InvocationCreator {
    protected Map<String, Object> parameters;
    protected OperationDescriptor descriptor;

    protected InvocationCreator(OperationDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public static InvocationCreator getCreator(OperationDescriptor descriptor) {
        if (descriptor.getScope() == OperationScope.TABLE) {
            return new TableScopedInvocationCreator(descriptor);
        }
        if (descriptor.getScope() == OperationScope.COLUMN) {
            return new ColumnScopedInvocationCreator(descriptor);
        }
        if (descriptor.getScope() == OperationScope.VOID) {
            return new VoidScopedInvocationCreator(descriptor);
        }
        throw new UnsupportedOperationException("Unable to create an invocation creator for the given operation scope: " + (Object)((Object)descriptor.getScope()));
    }

    public abstract OperationInvocation create();

    public InvocationCreator setTargetTable(TableId tableId) {
        throw new UnsupportedOperationException(String.format("The creator for the operation '%s' does not need a target table", this.descriptor.getName()));
    }

    public InvocationCreator setTargetColumn(ColumnLocalId columnId) {
        throw new UnsupportedOperationException(String.format("The creator for the operation '%s' does not need a target column", this.descriptor.getName()));
    }

    public InvocationCreator setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }
}

