package org.gcube.data.analysis.tabulardata.operation.worker;

import java.util.List;

import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;


public interface WorkerFactory {
	
	public OperationDescriptor getOperationDescriptor();

	public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException;
	
	public List<WorkerFactory> getPrecoditionValidations();
	
	public boolean isRollbackable();
	
	public Worker createRollbackWoker(Table diffTable, Table createdTable, OperationInvocation oldInvocation);
	
	public String describeInvocation(OperationInvocation toDescribeInvocation)throws InvalidInvocationException;
}
