/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.worker.results.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.InlineColumn;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.InlineRow;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.Resource;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InlineTable
implements Resource {
    private static final long serialVersionUID = 1805503093349235998L;
    private List<InlineColumn<?>> columns;
    private List<InlineRow> rows = new ArrayList<InlineRow>();

    public InlineTable(InlineColumn<?> ... columns) {
        this.columns = Arrays.asList(columns);
    }

    public void addRow(InlineRow row) {
        if (row.size() != this.columns.size()) {
            throw new RuntimeException("number of column si different to table declaration");
        }
        int i = 0;
        for (Object value : row.values) {
            if (value.getClass() == this.columns.get(i++).getType()) continue;
            throw new RuntimeException("value " + value + " not valid for this table (" + value.getClass() + ") ");
        }
        this.rows.add(row);
    }

    public Iterator<InlineRow> getData() {
        return this.rows.iterator();
    }

    public String getJSON() {
        return this.generateJSONFromData(this.getData());
    }

    private String generateJSONFromData(Iterator<InlineRow> dataIterator) {
        JSONObject json = new JSONObject();
        JSONArray jsonRows = new JSONArray();
        while (dataIterator.hasNext()) {
            List<Object> row = dataIterator.next().values;
            jsonRows.put(row);
        }
        try {
            json.put("rows", (Object)jsonRows);
        }
        catch (JSONException e) {
            throw new RuntimeException("Error occured with serialization of table content. Check server log.");
        }
        return json.toString();
    }

    @Override
    public String getStringValue() {
        return this.getJSON();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ATABLE;
    }
}

