package org.gcube.data.analysis.tabulardata.operation.worker.results.resources;

import java.util.Calendar;

public class ImmutableInlineTable implements ResourceDescriptorResult{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2378033798749961208L;

	private InlineTable aTable;
	private String description;
	private Calendar creationDate;
	private ResourceScope resourceScope = ResourceScope.LOCAL;
	
	
	public ImmutableInlineTable(InlineTable aTable,
			String description, Calendar creationDate) {
		super();
		this.aTable = aTable;
		this.description = description;
		this.creationDate = creationDate;
	}
	
	public ImmutableInlineTable(InlineTable aTable, String description,
			Calendar creationDate, ResourceScope resourceScope) {
		super();
		this.aTable = aTable;
		this.description = description;
		this.creationDate = creationDate;
		this.resourceScope = resourceScope;
	}

	@Override
	public InlineTable getResource() {
		return aTable;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public Calendar getCreationDate() {
		return creationDate;
	}

	@Override
	public ResourceScope getResourceScope() {
		return resourceScope;
	}
}
