package org.gcube.data.analysis.tabulardata.operation.data.remove;

import java.util.Map;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.DuplicateRowValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class DuplicateRowRemover extends Worker {
	
	private CubeManager cubeManager;
	private DatabaseConnectionProvider connectionProvider;
	private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
	private DuplicateRowValidatorFactory validatorFactory;
	
	Table targetTable;
	
	Table newTable;
	
	
	
	public DuplicateRowRemover(OperationInvocation sourceInvocation, CubeManager cubeManager,
			DatabaseConnectionProvider connectionProvider,
			SQLExpressionEvaluatorFactory sqlEvaluatorFactory,
			DuplicateRowValidatorFactory validatorFactory) {
		super(sourceInvocation);
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
		this.sqlEvaluatorFactory=sqlEvaluatorFactory;
		this.validatorFactory=validatorFactory;
	}

	@Override
	protected WorkerResult execute() throws WorkerException {
		targetTable = cubeManager.getTable(getSourceInvocation().getTargetTableId());
		updateProgress(0.1f);
		executeValidation();
		updateProgress(0.3f);		
		newTable=cubeManager.createTable(targetTable.getTableType()).like(targetTable, true).create();
		updateProgress(0.5f);
		filterValidatedTable();
		updateProgress(0.9f);				
		return new ImmutableWorkerResult(cubeManager.removeValidations(newTable.getId()));
	}

	private void filterValidatedTable() throws WorkerException{
		Column validationColumn = newTable.getColumnsByType(ValidationColumnType.class).get(0);
		Expression deleteCondition=new Equals(newTable.getColumnReference(validationColumn),new TDBoolean(false));
		executeFilter(deleteCondition);
	}
	
	private void executeFilter(Expression condition) throws WorkerException{
		try {
			String sqlCommand=String.format("DELETE FROM %s WHERE %s", newTable.getName(),sqlEvaluatorFactory.getEvaluator(condition).evaluate());			
			SQLHelper.executeSQLBatchCommands(connectionProvider, sqlCommand);
		} catch (Exception e) {
			throw new WorkerException("Error occurred while executing SQL command", e);
		}
	}

	
	private void executeValidation() throws WorkerException{
		WorkerWrapper wrapper=new WorkerWrapper(validatorFactory);
		Map<String,Object> map=getSourceInvocation().getParameterInstances();
		try{
			WorkerStatus status=wrapper.execute(targetTable.getId(), null, map);
			if(!status.equals(WorkerStatus.SUCCEDED))
				throw new WorkerException("Wrapped step has failed, see previous log");	
			targetTable=wrapper.getResult().getResultTable();
		}catch(InvalidInvocationException e){
			throw new WorkerException("Unable to check condition",e);
		}
	}
	
}
