package org.gcube.data.analysis.tabulardata.operation.data.add;

import java.util.Arrays;
import java.util.List;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ColumnTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.DataTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.LocalizedTextParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class AddColumnFactory extends TableTransformationWorkerFactory{

	private static final OperationId OPERATION_ID = new OperationId(1005);
	
	
	public static final DataTypeParameter DATA_TYPE=new DataTypeParameter("dataType", "Data Type", "To set data type", Cardinality.OPTIONAL);
	public static final ColumnTypeParameter COLUMN_TYPE=new ColumnTypeParameter("columnType","Column type","The type of the new column",Cardinality.ONE);
	public static final LocalizedTextParameter LABEL= new LocalizedTextParameter("label", "label", "To set label", Cardinality.OPTIONAL);
	
	
	
	private static List<Parameter> parameters=Arrays.asList(new Parameter[]{
		COLUMN_TYPE,
		DATA_TYPE,
		LABEL
	});
	
	
	@Inject
	private CubeManager cubeManager;

	@Override
	public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
		performBaseChecks(invocation,cubeManager);
		checkAllowedColumnDataCombination(invocation);
		return new AddColumn(invocation, cubeManager);
	}

	@Override
	protected String getOperationName() {
		return "Adds a column";
	}

	@Override
	protected String getOperationDescription() {
		return "Adds a column to a table";
	}

	@Override
	protected OperationId getOperationId() {
		return OPERATION_ID;
	}
	
	
	@Override
	protected List<Parameter> getParameters() {
		return parameters;
	}
	
	private void checkAllowedColumnDataCombination(OperationInvocation invocation) throws InvalidInvocationException{
		throw new InvalidInvocationException(invocation, "");
	}
}
